set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4114',
      '42034330',
      68,
      NULL,
      '1414414',
      82.786392,
      3,
      2.092262,
      2,
      NULL,
      3.023034,
      ' 5- 4-1985',
      66,
      NULL,
      0.220853,
      NULL,
      NULL,
      2,
      2,
      0.968415,
      0.934580,
      0.714409,
      1.505327,
      2.245249,
      3,
      NULL,
      8.072881,
      1,
      0,
      0.519807,
      1.288275,
      NULL,
      1.954974,
      NULL,
      NULL,
      3.583414,
      8.413352,
      NULL,
      5,
      1,
      5,
      2.260057,
      0.932201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.718021,
      1.612671,
      1.343789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.501541,
      0.033104,
      3.378718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.960310,
      2,
      1.787633,
      0.598220,
      NULL,
      NULL,
      3,
      1.489305,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.146698,
      1.819096,
      NULL,
      NULL,
      1,
      1,
      1.146254,
      0,
      NULL,
      4.284967,
      5,
      0,
      NULL,
      1,
      0,
      NULL,
      0.797277,
      0,
      NULL,
      0,
      0.140502,
      0,
      0,
      0.216533,
      0.472417,
      3.578078,
      2,
      1,
      6.644493,
      2,
      0,
      NULL,
      3,
      0,
      1,
      NULL,
      1.177055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.935031,
      0,
      1,
      1.475741,
      2.850731,
      0,
      0.284268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.202560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.752889,
      1,
      0.426853,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.703961,
      0.126139,
      3.373790,
      3.442975,
      1,
      NULL,
      1.973843,
      0.091630,
      NULL,
      1.751477,
      NULL,
      0,
      0,
      0.663089,
      1.229799,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.363056,
      '30320',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      2.635352,
      '1002',
      '',
      NULL,
      1,
      2.923184,
      1,
      5.816008,
      0,
      0.504856,
      3.143326,
      2.239300,
      1);
commit;
end;
/


