set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1200',
      '03311111',
      55,
      75,
      NULL,
      NULL,
      1,
      3.101376,
      NULL,
      '144310',
      NULL,
      '10-29-1974',
      21,
      127,
      1.803994,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.074837,
      NULL,
      1,
      NULL,
      0.838881,
      NULL,
      NULL,
      0,
      NULL,
      1.485157,
      0,
      9.147959,
      0.216916,
      2,
      1,
      3,
      0.140285,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.286175,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0.729689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.885601,
      0,
      1.878873,
      5.932987,
      1,
      3,
      0.788955,
      0.060418,
      1,
      0,
      0,
      1.053862,
      4.651418,
      NULL,
      1,
      NULL,
      0.797107,
      1.957045,
      NULL,
      NULL,
      1.514534,
      1,
      NULL,
      0,
      1,
      0.083288,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      1.046439,
      4,
      NULL,
      4.704281,
      2.961907,
      0.352372,
      7.829742,
      NULL,
      1.942447,
      2,
      2.372059,
      NULL,
      3.075325,
      1.352828,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0.256247,
      0.858535,
      0.127930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.370085,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1.912467,
      NULL,
      0.143275,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.488269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.137286,
      1.352330,
      NULL,
      1,
      3,
      2,
      0.784101,
      0.664992,
      NULL,
      2.561255,
      0.431528,
      1.908987,
      0.934409,
      1.943988,
      NULL,
      0.284153,
      1.527527,
      1.650908,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '14240',
      '',
      '',
      1.156135,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      3.155699,
      NULL,
      2,
      1,
      1.071862,
      NULL,
      2.398510,
      NULL,
      2.542884);
commit;
end;
/


