set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2203',
      '23000433',
      52.334925,
      61.061551,
      '4121404',
      222.617179,
      NULL,
      3,
      1,
      '401020',
      NULL,
      NULL,
      10.435251,
      NULL,
      0.402847,
      NULL,
      1,
      NULL,
      2.971183,
      0.863055,
      1,
      0,
      0,
      1,
      0.411664,
      0.371249,
      0,
      0.325424,
      1.334088,
      5,
      NULL,
      1.017013,
      11,
      1,
      5.663457,
      5,
      0.996197,
      2,
      5.673756,
      1,
      0.560396,
      0.644155,
      1.480149,
      1.082324,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.160373,
      0,
      0.699971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.011459,
      1.333459,
      1.274974,
      3.128961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.964993,
      NULL,
      2,
      4,
      1,
      0.462763,
      0.004134,
      1.839526,
      1,
      1.573836,
      0,
      NULL,
      0,
      1,
      0.148280,
      1.246922,
      NULL,
      1,
      NULL,
      1,
      5.503352,
      NULL,
      NULL,
      0,
      1,
      4,
      0.497464,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7,
      NULL,
      3,
      5.537103,
      0.469370,
      7,
      2.061994,
      NULL,
      NULL,
      2.540940,
      7.191188,
      NULL,
      6.624171,
      3.046987,
      0.236596,
      1.935455,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.179520,
      1.282117,
      NULL,
      1,
      1.979583,
      NULL,
      NULL,
      1.458597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.784002,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      0.172642,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.249231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.805896,
      3.378832,
      2.382593,
      3,
      2.653895,
      2,
      1.179806,
      NULL,
      0.096024,
      2,
      1.204486,
      1.746201,
      NULL,
      1.502013,
      NULL,
      NULL,
      0.724862,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.702026,
      '21124',
      '',
      '',
      1.777346,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1.605396,
      1,
      2,
      2.240231,
      0.958622,
      1,
      0,
      NULL,
      1.275726);
commit;
end;
/


