set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9334584';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '002',
      '04',
      NULL,
      10,
      '0421310',
      3.737185,
      0,
      0,
      NULL,
      '241234',
      4,
      ' 6-23-2000',
      42.654763,
      9,
      1.797976,
      NULL,
      NULL,
      1,
      1.958736,
      NULL,
      0,
      0.702925,
      NULL,
      1,
      0,
      0.130300,
      2,
      NULL,
      NULL,
      0,
      0.444231,
      1,
      0,
      0,
      1.248914,
      NULL,
      0.820206,
      0,
      4.060076,
      NULL,
      NULL,
      0.629550,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.932269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2.965582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.648098,
      NULL,
      0.543543,
      NULL,
      3.339171,
      4.878077,
      5,
      1,
      1,
      1.053465,
      0.634238,
      2.596871,
      NULL,
      NULL,
      1,
      1,
      0,
      1.639903,
      1.405638,
      NULL,
      NULL,
      NULL,
      NULL,
      1.943260,
      2.619181,
      1,
      5.304526,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.255809,
      2,
      0,
      NULL,
      1,
      3.521341,
      0.506685,
      0.642693,
      NULL,
      6.914477,
      7,
      1,
      1.401707,
      1.341772,
      1,
      NULL,
      NULL,
      3,
      1.164129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625078,
      0,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.151689,
      2,
      0.494762,
      0.138575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.010021,
      0,
      NULL,
      NULL,
      NULL,
      0.817139,
      1.060225,
      NULL,
      3,
      3.601883,
      NULL,
      1.523836,
      0.150372,
      NULL,
      NULL,
      0.245230,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.515204,
      1.531874,
      1,
      2,
      3,
      3.381636,
      1.453485,
      3.225390,
      1,
      0,
      NULL,
      0.941308,
      NULL,
      1.699121,
      1,
      1.292749,
      NULL,
      1.207300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '14330',
      '',
      '',
      2,
      '01331',
      '',
      '',
      0.513283,
      '',
      '',
      NULL,
      6.711299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


