set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9334584';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12',
      29,
      8.302217,
      NULL,
      NULL,
      5,
      0.308013,
      1,
      '124324',
      2,
      ' 2-18-1976',
      104.681332,
      56,
      1.369796,
      NULL,
      0.306720,
      0,
      1.754520,
      NULL,
      1,
      1.422203,
      0.005067,
      1.839669,
      0.164909,
      0,
      NULL,
      0.792258,
      0.453786,
      0,
      0.295077,
      NULL,
      0.659652,
      0,
      0.523608,
      0.675765,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      1.524440,
      NULL,
      NULL,
      1.125735,
      NULL,
      NULL,
      0.216082,
      NULL,
      0.535634,
      1.952871,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      4,
      0,
      0,
      NULL,
      0.244893,
      1.186103,
      0,
      3.609130,
      1.099263,
      1,
      1.749360,
      1,
      0.274579,
      NULL,
      1.701109,
      3,
      0.804269,
      NULL,
      1.027362,
      1.894684,
      5.195321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      5,
      3.463855,
      5,
      6,
      5.374468,
      4.178079,
      3.060288,
      6.620790,
      NULL,
      7,
      11,
      3.262078,
      NULL,
      0.687554,
      0.241982,
      NULL,
      NULL,
      2.110754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.217646,
      1,
      1,
      0,
      0.543158,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      8.532374,
      1,
      NULL,
      3.402290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.947615,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.534829,
      1.549457,
      NULL,
      NULL,
      5,
      0,
      7,
      1,
      NULL,
      NULL,
      0.566461,
      3,
      0.116429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.886491,
      NULL,
      1,
      NULL,
      1.177189,
      2.848856,
      2.782951,
      0,
      2.659379,
      0,
      NULL,
      0.251891,
      1.879240,
      1.594573,
      1,
      0,
      0.273755,
      1.505820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.927855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      0.004556,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


