set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9334584';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '402',
      '32030400',
      10,
      NULL,
      '2200304',
      NULL,
      5,
      NULL,
      1,
      '144104',
      4.558951,
      ' 8- 8-1993',
      169,
      75,
      0.319405,
      NULL,
      0,
      0,
      2.849643,
      NULL,
      NULL,
      1.262228,
      0,
      NULL,
      NULL,
      0.632197,
      1.666314,
      1,
      NULL,
      1.269217,
      0,
      0,
      0,
      0.816222,
      NULL,
      0.025538,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.742998,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909140,
      1.565395,
      NULL,
      0.255511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192548,
      0.954461,
      1.342172,
      NULL,
      1,
      0,
      1,
      1.053048,
      0.212162,
      1,
      0,
      2.146872,
      NULL,
      1.147119,
      NULL,
      1,
      0,
      NULL,
      1,
      4.981059,
      1,
      0.845664,
      1.475596,
      1.786175,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.649748,
      1,
      1.528893,
      NULL,
      2.484997,
      3.581724,
      NULL,
      7,
      4.323796,
      6,
      2,
      NULL,
      3,
      1.971230,
      0,
      1,
      1.727489,
      NULL,
      NULL,
      NULL,
      1.255936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.980201,
      1,
      1,
      NULL,
      1,
      1,
      1.630240,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.176477,
      NULL,
      1,
      NULL,
      2,
      0,
      0.975313,
      NULL,
      NULL,
      NULL,
      0.320431,
      1,
      0.541044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.924836,
      0.601140,
      0,
      1.562815,
      1,
      NULL,
      0.817798,
      1.930210,
      1.198144,
      NULL,
      1,
      0,
      1,
      1.115699,
      1.915955,
      1.238185,
      1.639894,
      1,
      0.654677,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '04040',
      NULL,
      '',
      1,
      NULL,
      NULL,
      '',
      1.981368,
      '',
      '',
      '',
      NULL,
      0.535622,
      0.285509,
      6.309012,
      2,
      3,
      0,
      1,
      NULL);
commit;
end;
/


