set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9334584';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '123',
      '44113110',
      31.332825,
      27.487361,
      '1430123',
      41.666079,
      6,
      3,
      0,
      '020332',
      NULL,
      ' 3-12-2003',
      67,
      209,
      1.514314,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.972268,
      0,
      NULL,
      1,
      1.631878,
      1,
      NULL,
      1,
      0,
      0.809341,
      0,
      0,
      1.656292,
      0,
      1,
      1.334704,
      0.723885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068136,
      0.188400,
      1.292157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.005681,
      1.615009,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.993215,
      1.787143,
      1.978325,
      0.832274,
      1.267497,
      0,
      1.405608,
      0,
      1,
      1.858976,
      0,
      2.268895,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.091365,
      1,
      2.219515,
      0,
      2.238794,
      2.126856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635439,
      0.721775,
      0.683566,
      NULL,
      1,
      1.724381,
      2.910141,
      0.359414,
      4.882681,
      1,
      NULL,
      3.301282,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4.905157,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.834703,
      1.640527,
      0,
      1,
      NULL,
      1.784663,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.488472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445075,
      NULL,
      1,
      0.352361,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.516274,
      0.991077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.589664,
      NULL,
      1.875911,
      0.638601,
      1,
      0.932293,
      0,
      0.306567,
      0,
      1.393459,
      0,
      0.886890,
      NULL,
      1.615282,
      NULL,
      1.181971,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.014418,
      NULL,
      '',
      '',
      1.105624,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      3.953814,
      2,
      2.136804,
      1,
      NULL,
      2.468680,
      3,
      0,
      1);
commit;
end;
/


