set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '230',
      NULL,
      NULL,
      NULL,
      NULL,
      49.701371,
      NULL,
      3.888692,
      3,
      '313234',
      4.341543,
      ' 9- 6-1984',
      57.698050,
      10,
      1.500289,
      NULL,
      0.061100,
      1.974259,
      3,
      NULL,
      NULL,
      0,
      0,
      1.214031,
      1,
      NULL,
      5.217023,
      NULL,
      1.774871,
      1.821863,
      0.882848,
      1,
      5.415423,
      1,
      0.978643,
      0,
      NULL,
      0.197632,
      7,
      0,
      0.596225,
      1.403355,
      NULL,
      1,
      NULL,
      NULL,
      0.579158,
      NULL,
      NULL,
      3,
      3,
      1.404268,
      2,
      1,
      2,
      0.726939,
      NULL,
      NULL,
      1,
      1.188622,
      NULL,
      0,
      1.567637,
      1,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      3,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.554761,
      NULL,
      0.813844,
      0,
      NULL,
      0.370946,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.830237,
      0,
      0.328093,
      0,
      1.258269,
      NULL,
      0.110219,
      NULL,
      0.463773,
      NULL,
      1,
      5,
      0.372643,
      1.265762,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      4.276802,
      1,
      4.547792,
      3,
      2.800260,
      4,
      0.619336,
      5.485566,
      0,
      0.506137,
      0,
      1,
      1,
      1.415497,
      5.626417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.669366,
      0.976917,
      2,
      0,
      1.330939,
      0.914820,
      0.542440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.554904,
      NULL,
      NULL,
      NULL,
      3,
      2.126480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.212086,
      NULL,
      1,
      3,
      0.663702,
      5,
      NULL,
      2.533423,
      NULL,
      1.982960,
      NULL,
      NULL,
      NULL,
      0,
      1.966218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.721504,
      NULL,
      NULL,
      NULL,
      NULL,
      1.349133,
      0.705682,
      2,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      1.600365,
      1.766315,
      1.131459,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      '',
      '',
      1.040028,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


