set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-8-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '423',
      '34',
      39,
      23,
      '3420130',
      18,
      2,
      NULL,
      3,
      '342123',
      NULL,
      ' 4- 3-1997',
      12,
      41,
      0.668093,
      NULL,
      NULL,
      1.349357,
      1.141996,
      0,
      NULL,
      1.193017,
      NULL,
      3,
      1.530767,
      1.733206,
      5,
      NULL,
      3.086223,
      0.852844,
      0.000759,
      0.527562,
      4,
      1.964368,
      NULL,
      1.544158,
      NULL,
      0,
      NULL,
      1,
      0.777791,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.234736,
      NULL,
      NULL,
      NULL,
      5.905457,
      0,
      2,
      1.526300,
      0,
      1.919955,
      0,
      0.973176,
      NULL,
      2.082429,
      0.296611,
      0,
      NULL,
      NULL,
      1.827117,
      0.671626,
      2.502179,
      2.190204,
      0,
      0.576952,
      NULL,
      1.509042,
      1,
      1,
      3.646798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.511483,
      0.677635,
      3,
      1,
      1,
      0,
      1.713076,
      0.411947,
      0,
      0.849687,
      NULL,
      0,
      0.923433,
      0,
      NULL,
      1.390484,
      0.071857,
      NULL,
      1.500121,
      NULL,
      1.567340,
      NULL,
      1.753264,
      2.820678,
      1.131368,
      1,
      2.114664,
      2.918704,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.037402,
      1.377114,
      NULL,
      0,
      NULL,
      0.822020,
      2,
      1,
      1.371374,
      3.622420,
      1.649875,
      3.538462,
      0.097668,
      4,
      4.913461,
      NULL,
      NULL,
      NULL,
      NULL,
      1.097795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.425538,
      1.675469,
      2,
      0,
      1,
      0.004486,
      0.807813,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.109493,
      NULL,
      8,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.090957,
      1,
      1.313785,
      NULL,
      0,
      1,
      5,
      NULL,
      0.131540,
      1.857401,
      4,
      NULL,
      2.928182,
      0,
      NULL,
      NULL,
      0.337110,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      NULL,
      0.347255,
      0,
      1,
      0.007679,
      0,
      2,
      1,
      NULL,
      0.318633,
      1,
      0.374923,
      0.996664,
      1.837713,
      1.901517,
      1.357809,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.102375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      '',
      '',
      1.381169,
      '',
      '',
      '',
      0.343484,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


