set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '433',
      '34',
      13,
      8,
      '0232132',
      16.333149,
      NULL,
      NULL,
      3,
      '331334',
      5.078687,
      ' 7- 8-1981',
      10.502477,
      57,
      0,
      NULL,
      1,
      0.562141,
      0,
      1,
      1.993720,
      NULL,
      0,
      0,
      NULL,
      NULL,
      7,
      0,
      NULL,
      0.198614,
      0,
      1,
      NULL,
      0.887146,
      0,
      0,
      NULL,
      1.618657,
      6,
      0,
      NULL,
      1,
      NULL,
      1.704082,
      NULL,
      NULL,
      0.817108,
      NULL,
      NULL,
      7,
      3.904926,
      0.412887,
      3,
      1.941678,
      NULL,
      NULL,
      0,
      NULL,
      0.945572,
      NULL,
      0.002807,
      0.217273,
      0.093185,
      NULL,
      1.338380,
      NULL,
      0.528812,
      0,
      4.598645,
      1,
      1,
      6,
      0,
      NULL,
      3.968631,
      0.285505,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.017824,
      0.938060,
      0.734294,
      1,
      1.534872,
      NULL,
      0,
      0,
      0,
      0.182960,
      0,
      NULL,
      NULL,
      NULL,
      0.280145,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.969618,
      1.458186,
      0,
      0,
      2.827981,
      1,
      1.718767,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.426123,
      NULL,
      0,
      5,
      4.950580,
      0,
      4.209578,
      0.405719,
      NULL,
      NULL,
      3.505287,
      4,
      NULL,
      3.515576,
      NULL,
      1.246296,
      1,
      2.277356,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.562788,
      1,
      1,
      0.435712,
      1,
      1,
      0.718697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.638097,
      NULL,
      9,
      2,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.715321,
      0,
      0.272748,
      1.327183,
      2,
      0.657511,
      5.510388,
      1,
      5,
      2,
      5.640265,
      1,
      0.007089,
      0,
      NULL,
      NULL,
      1.606348,
      0.232189,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      1.554582,
      1.155040,
      0.928442,
      1.122083,
      1,
      1.790903,
      NULL,
      1.434153,
      0,
      NULL,
      0.778564,
      0,
      1.676962,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '11441',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.910725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


