set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '312',
      NULL,
      33,
      25,
      '3120232',
      97,
      0,
      1.107488,
      0,
      '102413',
      1,
      ' 6-23-1991',
      NULL,
      139.624550,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      0.706060,
      1.219725,
      0,
      NULL,
      0.586901,
      7,
      1,
      6,
      1,
      8.065279,
      NULL,
      8.846990,
      1,
      1.656378,
      3.243434,
      7.050976,
      6,
      6.023426,
      1,
      4.199350,
      0,
      1,
      1.924686,
      NULL,
      NULL,
      0.639828,
      NULL,
      NULL,
      NULL,
      7.846824,
      4.875744,
      0.145312,
      0.391233,
      1.952174,
      NULL,
      0,
      1.871491,
      3.391354,
      1,
      0.392234,
      0.752770,
      1,
      2.778129,
      0.788521,
      1,
      1.496161,
      0,
      3.681878,
      0.420540,
      3,
      9.161816,
      0,
      2,
      0,
      1.869373,
      NULL,
      NULL,
      0.210266,
      NULL,
      NULL,
      NULL,
      0.505268,
      NULL,
      5.105366,
      NULL,
      1.711569,
      NULL,
      NULL,
      NULL,
      NULL,
      0.542620,
      0,
      1.070466,
      0.888215,
      1.076687,
      1.935596,
      0,
      0.775511,
      1,
      NULL,
      0.330355,
      0.779839,
      0,
      4.614839,
      NULL,
      1.926994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.838964,
      0.320606,
      0.104414,
      1.553549,
      0.354168,
      2,
      1.423502,
      NULL,
      1,
      1,
      5,
      0.940610,
      2.954204,
      1,
      NULL,
      NULL,
      0.513329,
      NULL,
      0,
      0.218877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.877316,
      NULL,
      2,
      0,
      NULL,
      1.665633,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3.406591,
      1,
      1.865082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.894288,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4,
      6,
      0.703862,
      NULL,
      0.184590,
      NULL,
      NULL,
      NULL,
      1.633645,
      NULL,
      1.140657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.654555,
      2,
      0.208074,
      1.028960,
      3,
      NULL,
      0,
      1.965970,
      0,
      2,
      1,
      1,
      1,
      0,
      0.759926,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '32233',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      0.165340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


