set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '301',
      '23',
      7,
      20,
      '1224343',
      2.616818,
      1,
      1,
      3,
      '334321',
      5,
      NULL,
      39,
      NULL,
      NULL,
      NULL,
      0.992909,
      1.166416,
      1,
      0.635032,
      0.006560,
      0.759818,
      0,
      1,
      1.052715,
      1,
      8.245900,
      0,
      5,
      2.309399,
      NULL,
      0,
      6,
      NULL,
      0.860138,
      0,
      5,
      3,
      1.816883,
      0,
      0.245203,
      1,
      2.673708,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.764578,
      NULL,
      6,
      2,
      NULL,
      2,
      NULL,
      1.185027,
      0.782506,
      1.847134,
      2.345750,
      0,
      0,
      1.283961,
      1.659124,
      2.223670,
      1,
      2,
      2.066078,
      1,
      1,
      NULL,
      3,
      NULL,
      2,
      0.205731,
      1.412349,
      NULL,
      NULL,
      1.486224,
      NULL,
      NULL,
      0,
      NULL,
      2.423436,
      3,
      2.530576,
      4.718622,
      0,
      NULL,
      1,
      5,
      3,
      1.085554,
      NULL,
      5,
      0,
      1.398052,
      1.590673,
      0.662175,
      0,
      NULL,
      0,
      0,
      0.870371,
      4,
      0,
      NULL,
      1.802485,
      NULL,
      NULL,
      0,
      1,
      0.947512,
      NULL,
      0.858001,
      0,
      0.198496,
      1,
      6,
      4.169053,
      NULL,
      2.757552,
      4.996713,
      NULL,
      1,
      5,
      0,
      NULL,
      0,
      0.037634,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.891234,
      0,
      1,
      1,
      0.759746,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.974404,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.518940,
      0.513421,
      1,
      5,
      NULL,
      1,
      0.960544,
      NULL,
      NULL,
      NULL,
      1,
      2.592634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      3.324374,
      0.602774,
      3.683978,
      3,
      NULL,
      0.713586,
      NULL,
      0.334118,
      1.882809,
      0.249602,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.695061,
      1.732368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.716868,
      '34022',
      '',
      '',
      0.205027,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      3,
      3,
      3,
      2.282928,
      1,
      NULL,
      2,
      2.299830);
commit;
end;
/


