set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '244',
      NULL,
      29.433712,
      NULL,
      NULL,
      72,
      6,
      NULL,
      NULL,
      '113131',
      1,
      NULL,
      60,
      NULL,
      1.384532,
      NULL,
      1,
      0,
      NULL,
      0,
      0.008837,
      1,
      0.165118,
      0,
      1.874468,
      0.226480,
      1.034329,
      0,
      NULL,
      1.875205,
      5.307638,
      0.864653,
      3,
      0.349444,
      NULL,
      0,
      5,
      0.010382,
      7.246050,
      0,
      NULL,
      3,
      1.014169,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.194129,
      4,
      0,
      0.611597,
      1,
      0.175807,
      1,
      0.812929,
      1,
      2.629199,
      3,
      NULL,
      1,
      0.782599,
      NULL,
      NULL,
      1.690052,
      2.655229,
      2.680019,
      NULL,
      2.618091,
      NULL,
      2,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.839532,
      5,
      1.925067,
      2,
      5.743708,
      1,
      0.335870,
      NULL,
      3.865498,
      1.753220,
      0,
      0,
      2,
      NULL,
      0,
      1.405498,
      NULL,
      0.562327,
      NULL,
      1,
      1,
      5,
      1.923528,
      0,
      NULL,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691737,
      1,
      1.478153,
      0.330332,
      1,
      3,
      5,
      4.674910,
      2,
      2,
      NULL,
      1,
      4.442223,
      3.565937,
      1,
      NULL,
      0.073254,
      NULL,
      NULL,
      4.689853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0.877477,
      1.995833,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.211297,
      NULL,
      6,
      3,
      3.607896,
      4.319535,
      1.530583,
      0,
      0,
      1,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.559607,
      3.437513,
      3.130783,
      1,
      NULL,
      1,
      1.659935,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.571454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      3,
      1.193576,
      NULL,
      1,
      0,
      1,
      1,
      0.559032,
      NULL,
      1,
      1.660201,
      NULL,
      0,
      1.030492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '02341',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      0.998949,
      1.534786,
      1,
      0.178784,
      3,
      2,
      3.271001,
      1);
commit;
end;
/


