set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '143',
      '04440422',
      35,
      NULL,
      '0011442',
      30,
      NULL,
      0.061162,
      NULL,
      '243302',
      2.436415,
      ' 3-11-1995',
      28.650126,
      NULL,
      1,
      NULL,
      0.662783,
      1.246426,
      0,
      NULL,
      0,
      0.406823,
      1.845082,
      3.290830,
      0,
      0.098352,
      4,
      1,
      4.416180,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      0.279068,
      0.913806,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0.151457,
      NULL,
      NULL,
      1.408190,
      NULL,
      NULL,
      0.674177,
      0.942967,
      NULL,
      2.780820,
      1.081495,
      NULL,
      1.199198,
      1,
      0,
      1,
      0,
      0,
      2,
      0.761515,
      2,
      2.271928,
      1.187899,
      2.374059,
      0,
      2.778593,
      0.394951,
      0,
      NULL,
      1,
      2,
      2.071698,
      0.632796,
      NULL,
      NULL,
      0.820069,
      NULL,
      NULL,
      1,
      0.143937,
      NULL,
      1.747267,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5,
      0,
      NULL,
      0.604758,
      2.472335,
      0.966210,
      0,
      0,
      0.909288,
      0,
      NULL,
      0.313592,
      0.436820,
      NULL,
      1.057097,
      1.477467,
      2.814706,
      1,
      0.865041,
      NULL,
      NULL,
      NULL,
      NULL,
      0.437174,
      NULL,
      NULL,
      0.327534,
      3,
      NULL,
      3,
      7,
      3,
      NULL,
      3,
      NULL,
      NULL,
      0,
      2.673536,
      NULL,
      2,
      0.003675,
      NULL,
      NULL,
      1.162881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.475886,
      0,
      NULL,
      0,
      1.151261,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1.591957,
      2,
      3.261703,
      0,
      0,
      0.817144,
      NULL,
      7.584056,
      2,
      0.447494,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.412771,
      3.703967,
      2.163546,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.933432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.885504,
      1,
      NULL,
      2,
      1,
      2,
      NULL,
      1,
      0,
      NULL,
      2.544002,
      1.515014,
      1.120875,
      1,
      NULL,
      1.680743,
      0,
      NULL,
      1.915925,
      0.590601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '',
      '',
      0.795335,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      5,
      7,
      0,
      0,
      0,
      3,
      1,
      NULL,
      3.354411);
commit;
end;
/


