set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '32342120',
      0,
      27.015405,
      NULL,
      88.272371,
      6,
      1.319454,
      3,
      '040232',
      0.686760,
      ' 7- 8-1991',
      41,
      NULL,
      1,
      NULL,
      1.152506,
      0,
      3.442416,
      1.814028,
      NULL,
      NULL,
      1,
      3,
      1.557042,
      0,
      1,
      NULL,
      1,
      1,
      1.521177,
      0.944331,
      NULL,
      0.745516,
      NULL,
      0.164932,
      1,
      NULL,
      7.145068,
      0,
      0.110883,
      0,
      3,
      0.716702,
      NULL,
      NULL,
      1.329787,
      NULL,
      NULL,
      4,
      1.124778,
      3,
      3.828391,
      0.597608,
      2.265324,
      1,
      NULL,
      0.332712,
      0.254148,
      2,
      1,
      1.455769,
      NULL,
      2.543116,
      1.689127,
      3,
      NULL,
      NULL,
      0.326963,
      0,
      1.077201,
      NULL,
      NULL,
      2,
      3,
      0.264906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.086986,
      NULL,
      1.856392,
      1,
      0.364083,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.211049,
      0,
      1.082496,
      1,
      0.587640,
      NULL,
      0.917710,
      1,
      1,
      4,
      0.125621,
      1.537304,
      3.211573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.892283,
      1,
      3,
      NULL,
      6,
      6.436082,
      5,
      1,
      NULL,
      1.059248,
      NULL,
      3.407327,
      2.800318,
      3.782546,
      NULL,
      0.897602,
      2.056624,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.582882,
      1,
      1,
      0,
      NULL,
      0,
      0,
      1.040299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.684691,
      NULL,
      0.473482,
      NULL,
      NULL,
      NULL,
      0.354145,
      0,
      2,
      0.576504,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.131907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.697545,
      3,
      3,
      3.597355,
      NULL,
      3,
      2.956668,
      0,
      1,
      3.585009,
      0,
      1.277767,
      0.503550,
      0,
      0.378387,
      0.213380,
      1,
      0,
      NULL,
      0.497548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.947082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '42302',
      '',
      '',
      0.785001,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      0,
      3.249988,
      NULL,
      0.858930,
      NULL,
      3.308819,
      NULL,
      NULL);
commit;
end;
/


