set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '03220341',
      73.075201,
      NULL,
      '2230334',
      64.506261,
      5,
      NULL,
      1,
      NULL,
      0.349010,
      ' 4- 3-1991',
      17,
      113,
      1,
      NULL,
      1.099882,
      1,
      3,
      0.599667,
      1,
      0,
      1,
      2.744830,
      1.925216,
      1.422179,
      2.059430,
      NULL,
      8,
      0.844383,
      NULL,
      NULL,
      5.602952,
      0.554677,
      1.930037,
      0.432672,
      0.939042,
      1.356491,
      2,
      NULL,
      2.212572,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      9.907113,
      5,
      3,
      3,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.497779,
      NULL,
      2.012360,
      NULL,
      2.496836,
      0,
      3.840831,
      1,
      0,
      1.329396,
      5,
      1,
      0,
      1.036643,
      1.414753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.866090,
      NULL,
      0.487833,
      1.499186,
      2,
      2.913234,
      0,
      3,
      NULL,
      1.734437,
      0,
      NULL,
      3.315647,
      1,
      NULL,
      0.162126,
      0.971985,
      0.786658,
      NULL,
      0,
      0,
      1,
      1.803578,
      NULL,
      0,
      0.751332,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.414944,
      1,
      1.221881,
      0,
      2,
      5,
      1,
      3.211906,
      NULL,
      0,
      NULL,
      NULL,
      7.914516,
      0,
      4,
      5.816878,
      2,
      0.369251,
      1,
      1.670660,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.971710,
      NULL,
      0,
      1,
      0.976460,
      0,
      0.970980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      8.754744,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.840400,
      0.400202,
      0.104735,
      0.676646,
      3,
      1,
      6.031681,
      0,
      NULL,
      4.721577,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5.778754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.348951,
      3,
      1,
      NULL,
      0.037856,
      0.420736,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      1.581510,
      NULL,
      0,
      0.950489,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '44133',
      '',
      '',
      0.507982,
      '',
      '',
      '',
      1.284692,
      '',
      '',
      '',
      2.016840,
      NULL,
      3,
      3.738367,
      NULL,
      1,
      0.891975,
      1,
      1);
commit;
end;
/


