set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '221',
      '20033204',
      65,
      NULL,
      '4334441',
      80.382826,
      2,
      1.118782,
      NULL,
      NULL,
      1.202879,
      '11-25-1975',
      37.921091,
      36.843252,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.533700,
      1,
      0,
      1.802058,
      0,
      0.635071,
      5,
      1.893253,
      2,
      1,
      NULL,
      2,
      NULL,
      1,
      0,
      1,
      1,
      0,
      2.904966,
      1,
      2.039531,
      2.594361,
      2.420676,
      1,
      NULL,
      NULL,
      0.428256,
      5.843045,
      3,
      2,
      2,
      0.180473,
      1,
      1.361543,
      1.351756,
      3.292999,
      2.339913,
      1.041428,
      1,
      3.951621,
      0.869603,
      2.912338,
      1.432023,
      0,
      0.688008,
      2.965279,
      1.534555,
      3,
      NULL,
      1.362864,
      1.670103,
      8.297013,
      0,
      1,
      2.846935,
      NULL,
      NULL,
      NULL,
      2.358027,
      0.556716,
      2.557841,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2.663103,
      0.111155,
      0,
      NULL,
      1,
      0,
      1,
      0.774856,
      2.183601,
      1,
      NULL,
      1.465481,
      0.155517,
      NULL,
      NULL,
      0,
      1.492137,
      0.894411,
      NULL,
      NULL,
      4.078059,
      3.705877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.462906,
      NULL,
      0,
      0.584331,
      0,
      2.209573,
      7.500063,
      7.198114,
      NULL,
      7,
      1,
      2.613945,
      7,
      0.349143,
      2,
      1.920269,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.798279,
      1,
      0,
      0.332029,
      0.944897,
      1.264597,
      0.380527,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.046493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.106064,
      1,
      1,
      0,
      2.458589,
      NULL,
      1.502987,
      NULL,
      2,
      0,
      7.280229,
      NULL,
      0.333254,
      NULL,
      NULL,
      NULL,
      0.717476,
      7,
      2,
      2,
      0,
      6,
      NULL,
      1.210036,
      1.027554,
      NULL,
      0.074111,
      2,
      3,
      NULL,
      3,
      1,
      0.768900,
      0,
      3.114005,
      1.743679,
      1,
      0,
      1,
      NULL,
      1.813701,
      0,
      1.503777,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.737726,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      0.662794,
      '',
      NULL,
      NULL,
      5,
      5.209943,
      3,
      NULL,
      NULL,
      3.452468,
      2.634678,
      0,
      1);
commit;
end;
/


