set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '244',
      '20104234',
      41.007442,
      52.002511,
      NULL,
      56,
      0,
      3.089891,
      2,
      '021441',
      2,
      ' 0- 7-1994',
      3.606686,
      28,
      1,
      NULL,
      NULL,
      NULL,
      0.920510,
      NULL,
      NULL,
      0.261384,
      0.274825,
      2,
      1,
      1,
      3,
      1,
      3.648682,
      NULL,
      NULL,
      0.297215,
      4,
      1,
      0,
      1.736467,
      0,
      NULL,
      4,
      0,
      4,
      NULL,
      2.914050,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.030495,
      2.864497,
      7.851677,
      3,
      1,
      NULL,
      2,
      2.088165,
      0,
      0.568674,
      0,
      1,
      0.943466,
      1,
      2,
      0.254663,
      NULL,
      3.884349,
      1.155489,
      NULL,
      NULL,
      1.377360,
      NULL,
      0,
      2,
      NULL,
      1.038144,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.370151,
      1,
      3,
      1,
      4.131840,
      1.639796,
      0.977991,
      5.807179,
      2,
      NULL,
      0.940693,
      2,
      NULL,
      0,
      NULL,
      1.042338,
      1,
      NULL,
      0.374460,
      1.601510,
      1.903360,
      0,
      NULL,
      1,
      4.103553,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.977626,
      NULL,
      NULL,
      NULL,
      3.625075,
      3.303837,
      4.433301,
      1.867616,
      6.852197,
      4.081078,
      7.925486,
      3.761858,
      9,
      3.108280,
      0.939590,
      4.129956,
      2.996418,
      NULL,
      0.748871,
      7.260375,
      1.092125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.453663,
      1.284924,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.213143,
      NULL,
      3.081699,
      0,
      0.019505,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.478882,
      0.400077,
      NULL,
      NULL,
      NULL,
      5,
      5,
      3.403911,
      1,
      1.000513,
      2,
      0.113381,
      NULL,
      NULL,
      NULL,
      0.121587,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      3.329253,
      2.027281,
      3,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      0.027362,
      0.501101,
      NULL,
      NULL,
      0,
      NULL,
      1.946803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '30224',
      NULL,
      '',
      1.874018,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      5,
      2.998644,
      0,
      3.722043,
      0,
      1,
      3,
      NULL,
      1);
commit;
end;
/


