set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4431',
      '12114013',
      29.645332,
      4.415824,
      '4004032',
      23.904970,
      2,
      3.890585,
      3,
      '130334',
      NULL,
      NULL,
      37,
      9,
      1.331177,
      NULL,
      1.287024,
      3,
      NULL,
      NULL,
      NULL,
      0.352843,
      0,
      3.534911,
      0,
      0,
      4,
      1.439983,
      4,
      NULL,
      2,
      NULL,
      4,
      0,
      1.422093,
      0.625939,
      NULL,
      2,
      6,
      0,
      3.194047,
      NULL,
      1,
      1.176716,
      NULL,
      NULL,
      1.219652,
      NULL,
      NULL,
      NULL,
      6.889132,
      6,
      0,
      3,
      1.435850,
      NULL,
      3,
      1,
      0.356508,
      2.770925,
      1.430633,
      2,
      1.451588,
      NULL,
      0,
      2.732325,
      3,
      1.873969,
      0.964497,
      1.954853,
      1.480371,
      NULL,
      NULL,
      0,
      3.988175,
      0.622787,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.204507,
      0.466792,
      2,
      0,
      4,
      1.426200,
      0,
      0.515178,
      1.810099,
      4,
      3,
      0,
      0.329427,
      NULL,
      1.874546,
      0.260590,
      NULL,
      0,
      1,
      NULL,
      0,
      0.796802,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.999611,
      1,
      1.639099,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2.666441,
      1.636117,
      0.553285,
      5,
      3.967917,
      0.340892,
      NULL,
      5.437953,
      NULL,
      2.171370,
      2,
      NULL,
      5.720656,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.618994,
      NULL,
      9,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.729766,
      1,
      NULL,
      NULL,
      NULL,
      5.889910,
      NULL,
      6.036225,
      NULL,
      4.522654,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.129278,
      0.695863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.777356,
      3.050368,
      1.273036,
      1.976264,
      1,
      0.396339,
      NULL,
      0,
      1,
      0,
      1.973527,
      0.900406,
      1.545682,
      0,
      NULL,
      0,
      1.655821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '21123',
      '',
      '',
      0.682872,
      '',
      '',
      NULL,
      0.258622,
      '',
      '',
      '',
      4,
      7,
      3.487161,
      1,
      2.378815,
      NULL,
      0,
      1.179478,
      NULL);
commit;
end;
/


