set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0230',
      NULL,
      69.908544,
      79,
      '2333303',
      98,
      2,
      NULL,
      0,
      NULL,
      3,
      NULL,
      6.943519,
      NULL,
      1.893457,
      NULL,
      1,
      1.230386,
      0.072021,
      0.346145,
      NULL,
      1.895426,
      NULL,
      0,
      0,
      1,
      7,
      0.920730,
      NULL,
      NULL,
      0.495590,
      4,
      NULL,
      1.814781,
      1.073408,
      NULL,
      1,
      0.111929,
      9.414951,
      0,
      2,
      1.211097,
      2.989627,
      NULL,
      NULL,
      NULL,
      1.563058,
      NULL,
      NULL,
      6.576934,
      0.629307,
      3,
      3,
      2.455840,
      1,
      0.537209,
      2,
      1,
      1,
      3,
      0,
      1,
      1,
      NULL,
      0.620529,
      0,
      2.613371,
      0,
      2,
      0,
      NULL,
      6,
      1,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      5.932566,
      0,
      3.927958,
      NULL,
      4.487595,
      NULL,
      0,
      0.976106,
      1.553557,
      1,
      1.308134,
      4,
      NULL,
      1.040508,
      NULL,
      1,
      1,
      NULL,
      1,
      0.443915,
      1,
      0,
      0.967539,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.402673,
      NULL,
      0,
      3,
      1.642742,
      NULL,
      0,
      4.950200,
      NULL,
      6.734288,
      NULL,
      4.616614,
      0,
      NULL,
      3,
      NULL,
      NULL,
      0.966756,
      1.046180,
      1.869882,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.509575,
      0,
      1,
      1.882200,
      1.284486,
      1.296964,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.104391,
      NULL,
      2,
      0,
      2.849238,
      1.502387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.444091,
      3.477292,
      0.328852,
      NULL,
      0.313051,
      3,
      NULL,
      6,
      4.940652,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357402,
      9.612637,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.062440,
      NULL,
      0,
      1.462147,
      2.749861,
      NULL,
      NULL,
      0.763306,
      0,
      1.430135,
      NULL,
      0,
      0,
      1.919098,
      1.507866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.103624,
      '22131',
      '',
      NULL,
      0.473247,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      5,
      0,
      NULL,
      1.895175,
      2.636730,
      3,
      NULL,
      1.604218);
commit;
end;
/


