set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4032',
      NULL,
      61,
      68.372319,
      '3344424',
      126,
      NULL,
      1,
      0,
      NULL,
      4,
      ' 1- 3-1995',
      59,
      7.803838,
      NULL,
      NULL,
      1.028466,
      NULL,
      1,
      1.319978,
      1.774220,
      0.241785,
      1,
      0,
      0,
      NULL,
      7,
      0.976086,
      1.510240,
      0.519488,
      9.094037,
      1.061744,
      1,
      1,
      1,
      0.333037,
      1,
      1.708487,
      NULL,
      0,
      0.814130,
      2.821881,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.824492,
      5,
      8,
      3,
      0.000826,
      2,
      2,
      0.955322,
      1,
      0.933335,
      1.202324,
      1.188362,
      1.103852,
      2.291429,
      0,
      1.265719,
      2.929312,
      1.546763,
      NULL,
      1.712107,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.098627,
      0.944103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.795892,
      5,
      0.848331,
      0.765995,
      1,
      NULL,
      3.030943,
      NULL,
      0.651264,
      NULL,
      NULL,
      0.788991,
      1.107512,
      5.552259,
      1,
      1,
      1,
      1.314088,
      1,
      NULL,
      0.269695,
      0.807030,
      0.144584,
      NULL,
      NULL,
      NULL,
      NULL,
      0.934059,
      NULL,
      NULL,
      NULL,
      NULL,
      0.420072,
      1.972659,
      NULL,
      NULL,
      NULL,
      7,
      5,
      7.705629,
      1,
      NULL,
      7,
      6,
      0,
      0,
      3.685722,
      3.762142,
      1,
      1.228941,
      1,
      3,
      1.534145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.012726,
      0.642319,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      2.222225,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.720753,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.526009,
      7,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.447795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3.042721,
      0,
      NULL,
      3.516378,
      0,
      1.451056,
      0.769977,
      0,
      1,
      0,
      1,
      0.053872,
      1.856934,
      0.385684,
      0,
      1,
      0.065433,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '02340',
      NULL,
      '',
      0,
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      NULL,
      1,
      2.997945,
      1.671482,
      3,
      NULL,
      NULL,
      4.720820,
      NULL,
      1);
commit;
end;
/


