set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1043',
      '43311010',
      92.630901,
      76.398326,
      '2121043',
      62.734521,
      NULL,
      0.999647,
      1,
      '413213',
      3,
      NULL,
      8.045770,
      22,
      0,
      NULL,
      1.288425,
      0.920318,
      0.059467,
      1.910240,
      1,
      0,
      0.871183,
      1,
      1.075427,
      1,
      6,
      0,
      2.673211,
      1.372968,
      5,
      0,
      3,
      NULL,
      NULL,
      1.743718,
      0,
      3,
      NULL,
      0,
      3.759400,
      3.793709,
      NULL,
      0,
      NULL,
      NULL,
      1.641210,
      NULL,
      NULL,
      3,
      3.514428,
      0,
      0,
      1,
      1,
      3.996531,
      2,
      3,
      1.484222,
      1,
      NULL,
      NULL,
      NULL,
      0.349345,
      1,
      NULL,
      3,
      NULL,
      8.756095,
      1,
      1,
      8,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      1.305356,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.573225,
      3.296160,
      3,
      NULL,
      1,
      NULL,
      7.419004,
      NULL,
      1.575253,
      1,
      4.403037,
      1.596011,
      1,
      0.457244,
      1.140426,
      0,
      NULL,
      0.940266,
      0.547110,
      5.360037,
      NULL,
      NULL,
      NULL,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.633765,
      NULL,
      1,
      NULL,
      7,
      8.139154,
      7,
      NULL,
      4,
      9.643087,
      1.835931,
      9,
      4.830605,
      0.852836,
      1,
      3.017118,
      0.273754,
      0.152623,
      6.098019,
      0.286104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.845933,
      NULL,
      0,
      0,
      1.974964,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      9,
      1,
      3,
      1.984792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.720653,
      2,
      0.762302,
      NULL,
      NULL,
      NULL,
      2.003160,
      5,
      5,
      4.047541,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.505540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081412,
      3.182660,
      1.003078,
      1.844293,
      3,
      3.905679,
      1,
      1,
      NULL,
      2,
      3.686805,
      1,
      1,
      0,
      0,
      NULL,
      1.565320,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '10241',
      '',
      '',
      0.193278,
      '',
      '',
      NULL,
      0.266400,
      '',
      '',
      '',
      3,
      4,
      0.703029,
      3.444443,
      0.589808,
      2.313889,
      1.150988,
      NULL,
      0);
commit;
end;
/


