set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-6-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '402',
      NULL,
      15,
      2.040821,
      '3140143',
      25,
      1,
      2,
      NULL,
      NULL,
      2,
      ' 4- 0-1988',
      38,
      36.786929,
      NULL,
      NULL,
      3,
      1,
      3,
      1,
      0.853645,
      3.730674,
      0,
      NULL,
      1.554644,
      1.848124,
      3.548134,
      1.754178,
      1,
      0.946692,
      1,
      NULL,
      1,
      1,
      1.482967,
      0,
      0.280469,
      1,
      3.275275,
      NULL,
      0,
      1,
      0,
      1.953284,
      NULL,
      NULL,
      0.712764,
      NULL,
      NULL,
      2.294778,
      2,
      NULL,
      2.131113,
      0,
      0.932488,
      1.932638,
      3.769226,
      1,
      NULL,
      3.147265,
      NULL,
      0,
      0.593242,
      NULL,
      0.582648,
      0,
      2.426071,
      3,
      0,
      1.978563,
      6,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3.734374,
      0,
      NULL,
      0.523584,
      1,
      0,
      1,
      1.562137,
      1.946868,
      0.064746,
      1.494551,
      1,
      NULL,
      0.432534,
      NULL,
      0,
      1.698048,
      NULL,
      1.609453,
      1,
      0.597918,
      0,
      0.745624,
      0,
      0,
      0.864682,
      2,
      NULL,
      1,
      NULL,
      1.531284,
      1.084290,
      3,
      NULL,
      0,
      4.503113,
      2,
      3,
      7,
      NULL,
      6.949704,
      4.343280,
      NULL,
      3,
      4,
      0,
      3,
      0.217591,
      0.275965,
      9,
      0.418425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.502795,
      0,
      0,
      0.478423,
      0.163101,
      0.913121,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      6.662239,
      2,
      0.900366,
      3.796902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.631872,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      2.265349,
      2,
      1.530701,
      NULL,
      NULL,
      NULL,
      1,
      0.806084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      1.641347,
      1.088455,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      0.302079,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      0.823037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.387607,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.018707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.511957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.624111,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0.556139,
      0,
      NULL,
      2,
      1.267644,
      '11133',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      5.907537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


