set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-10-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '242',
      '10',
      6.609861,
      NULL,
      '2042023',
      21.472296,
      0,
      2.088154,
      3,
      '010013',
      3.294908,
      ' 2-10-1981',
      31,
      7.976265,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0.449464,
      0.770754,
      0,
      0.309646,
      0.339416,
      NULL,
      1.744246,
      0.933256,
      5,
      NULL,
      2.689889,
      1.652143,
      NULL,
      1,
      NULL,
      1.474975,
      3,
      1,
      NULL,
      NULL,
      4,
      0,
      2.838575,
      0.100503,
      NULL,
      NULL,
      0.384319,
      NULL,
      NULL,
      1.700081,
      0.705244,
      NULL,
      2.311548,
      1.102320,
      1,
      NULL,
      3.622948,
      0.171243,
      0.808919,
      2.720872,
      1.474899,
      2,
      1,
      1.384248,
      1,
      0.549127,
      NULL,
      1.580701,
      0,
      1,
      6.858829,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2.657986,
      1,
      2,
      0,
      0,
      NULL,
      NULL,
      0.488215,
      NULL,
      NULL,
      0,
      0.248204,
      0.518754,
      1.812309,
      1.876408,
      0.788870,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.585449,
      1.590460,
      0.319953,
      0,
      1.914086,
      2,
      3,
      1.114336,
      0.108536,
      0,
      0,
      3.828175,
      0,
      3,
      7.254831,
      0.642927,
      0,
      NULL,
      0.634835,
      3.796980,
      NULL,
      1,
      0.547735,
      0.169318,
      4.002092,
      1,
      0.732028,
      NULL,
      0.631361,
      1.993759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.773168,
      NULL,
      1,
      1,
      0,
      1.550521,
      1.725417,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081458,
      NULL,
      NULL,
      NULL,
      NULL,
      1.139268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      2.757909,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.135024,
      1.609149,
      1.565905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.942976,
      1,
      0.614949,
      0.604037,
      NULL,
      NULL,
      1.673101,
      1,
      1,
      NULL,
      0.627693,
      0,
      1.794044,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.804405,
      '41324',
      '',
      '',
      1.000095,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2.594381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


