set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '104',
      '10',
      14.079215,
      17,
      '0243111',
      1,
      4,
      NULL,
      3,
      '220200',
      3,
      NULL,
      36,
      NULL,
      0,
      NULL,
      1.424704,
      0.382558,
      3,
      NULL,
      1.762196,
      1,
      0,
      1,
      0,
      1.093927,
      4,
      1.504869,
      2.929419,
      NULL,
      1.132201,
      NULL,
      2.834471,
      1,
      3.582626,
      4.173112,
      2,
      3.298056,
      0,
      0,
      4,
      2.328807,
      3,
      NULL,
      NULL,
      NULL,
      0.110975,
      NULL,
      NULL,
      3.155884,
      1,
      0.693202,
      1.973048,
      0,
      3,
      0,
      2.659786,
      0,
      1,
      3,
      0,
      2.110416,
      1.267734,
      NULL,
      1.237850,
      3,
      3,
      3.033992,
      0.453532,
      1,
      4.773849,
      NULL,
      0,
      NULL,
      2.846331,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.303047,
      1,
      4,
      NULL,
      0,
      2,
      0,
      0,
      0,
      5,
      1.373889,
      0.185367,
      1,
      NULL,
      0,
      0,
      1,
      1.234268,
      0.285584,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.979596,
      1,
      NULL,
      NULL,
      6.353219,
      1.297539,
      1,
      4.972075,
      5,
      1,
      NULL,
      0,
      2,
      4,
      NULL,
      1,
      0,
      NULL,
      0,
      0.758229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111565,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.824287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853571,
      0.838147,
      NULL,
      1.431014,
      1.277758,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.138029,
      0.529658,
      2,
      0,
      1,
      3.644303,
      0.141927,
      0.650545,
      1.674926,
      3.490340,
      NULL,
      1,
      NULL,
      0,
      0,
      0.439676,
      1.658950,
      0.726900,
      1.838886,
      0.022821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.919390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '32011',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      4.192315,
      4,
      3.782508,
      3,
      5.436702,
      3,
      NULL,
      1,
      2);
commit;
end;
/


