set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '342',
      '11123043',
      52,
      13.110342,
      '0340433',
      52.364490,
      0,
      NULL,
      0,
      '230314',
      4,
      NULL,
      41.475711,
      26,
      0,
      NULL,
      1,
      NULL,
      2.628505,
      0.638390,
      NULL,
      0.213112,
      0,
      NULL,
      0,
      1.665300,
      1,
      1.117797,
      1,
      1.267950,
      1,
      1,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1.334899,
      1,
      NULL,
      NULL,
      1.923458,
      0.487654,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.978481,
      0.107735,
      1,
      0.548513,
      2,
      3,
      2,
      1,
      1,
      2.188240,
      NULL,
      NULL,
      0.605896,
      NULL,
      0,
      0,
      2,
      2,
      1,
      0.566902,
      0,
      4,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1.171520,
      NULL,
      NULL,
      0.288991,
      0.846873,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.607631,
      0,
      1,
      0,
      0.099775,
      0.595879,
      3,
      1,
      0,
      0,
      1.634135,
      0,
      NULL,
      0,
      0.429606,
      0.383921,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.787495,
      1.143066,
      1,
      NULL,
      2,
      3,
      3.471045,
      NULL,
      NULL,
      0,
      2,
      4.840505,
      1,
      6,
      1.181055,
      3.359440,
      1,
      1.429181,
      6,
      0.387684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.142891,
      1,
      0,
      1,
      1.476143,
      0,
      1.755169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.034641,
      1,
      3.240970,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.584819,
      1.601450,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.851426,
      0,
      2.085125,
      3.181207,
      2.120605,
      1,
      0,
      1,
      NULL,
      2.120913,
      0.411018,
      0,
      1,
      0.818091,
      1,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.281161,
      '31442',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      1.554213,
      NULL,
      2,
      0.560757,
      2,
      1.471377,
      1.980083,
      0.888600);
commit;
end;
/


