set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '121',
      '41123043',
      30.216710,
      NULL,
      '3030314',
      83,
      4,
      0.035053,
      3,
      NULL,
      4.434338,
      ' 3-27-1998',
      50.661942,
      37.317266,
      1,
      NULL,
      NULL,
      1.676165,
      2.696962,
      NULL,
      1,
      0,
      1.341261,
      0.616844,
      0.256987,
      1,
      2,
      1.275563,
      1.173061,
      0,
      0.569511,
      1,
      3.061477,
      0.578055,
      0.820656,
      NULL,
      0,
      0,
      3.249572,
      1,
      1,
      NULL,
      1.918410,
      0.948119,
      NULL,
      NULL,
      1.987682,
      NULL,
      NULL,
      6.672528,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2.684403,
      0,
      1.946589,
      NULL,
      NULL,
      NULL,
      2.907151,
      0,
      NULL,
      0.845535,
      1,
      1,
      1.612951,
      0.114650,
      NULL,
      3.805574,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.228627,
      NULL,
      NULL,
      0.146989,
      1.570165,
      NULL,
      0,
      2.808060,
      3,
      1.467168,
      1.319978,
      NULL,
      3,
      0.301698,
      0,
      0.574055,
      1.140195,
      1,
      0,
      1.088476,
      1.016462,
      0.444433,
      NULL,
      1.822056,
      1,
      0.302296,
      1.532383,
      0.447448,
      1,
      1.373508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.083856,
      1,
      NULL,
      NULL,
      1.410835,
      1.422546,
      0,
      1.462331,
      2,
      0.985895,
      2.845237,
      2.534294,
      7.682733,
      0.484927,
      NULL,
      0,
      2.177119,
      0.533235,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.418408,
      NULL,
      0,
      1,
      1.842654,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.598162,
      NULL,
      NULL,
      NULL,
      NULL,
      0.976365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.897887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.517664,
      1.975823,
      3.850710,
      1.607746,
      1,
      0.761436,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.420384,
      1.436250,
      NULL,
      0.586362,
      1,
      NULL,
      1.150759,
      1.359172,
      1,
      NULL,
      1.416548,
      0,
      1.081384,
      1,
      1.200616,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.288577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.841740,
      0,
      1,
      NULL,
      0.977402,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335697,
      NULL,
      NULL,
      NULL,
      NULL,
      1.876689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.257003,
      '12113',
      '',
      '',
      1.152469,
      '',
      '',
      '',
      1.975826,
      '',
      '',
      '',
      0.155982,
      3.787330,
      0,
      0,
      0.975625,
      2.106641,
      3.120290,
      0,
      2.299957);
commit;
end;
/


