set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '323',
      '00444220',
      NULL,
      NULL,
      '3211411',
      38.351178,
      3,
      NULL,
      1,
      '210013',
      2,
      ' 5-20-1996',
      NULL,
      NULL,
      1,
      NULL,
      2.836952,
      NULL,
      1.218689,
      0.638941,
      1.980406,
      0,
      1.218449,
      1,
      0.379479,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.382712,
      NULL,
      0,
      0.358258,
      1,
      1.660619,
      1,
      NULL,
      4,
      1,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      NULL,
      1.640729,
      1,
      0,
      NULL,
      3.432442,
      3.661269,
      1,
      3,
      0,
      NULL,
      0,
      3,
      1.224081,
      1,
      3,
      0.972362,
      0.394384,
      1,
      1.339142,
      0,
      3,
      0,
      2,
      2.699917,
      1.738672,
      NULL,
      NULL,
      1.707676,
      NULL,
      NULL,
      0,
      0.572316,
      0,
      1,
      NULL,
      1.437034,
      1.241422,
      1,
      NULL,
      0,
      1.564801,
      0,
      1,
      NULL,
      1,
      0.309102,
      1,
      NULL,
      0,
      NULL,
      1.517244,
      0.763485,
      0.286113,
      1.290193,
      0,
      0.654715,
      1.122933,
      0.640165,
      0,
      NULL,
      1.182778,
      1.778040,
      NULL,
      NULL,
      1.394405,
      1,
      1,
      0.362995,
      0,
      0,
      1,
      0.939179,
      5,
      NULL,
      4,
      1.624367,
      NULL,
      0.835318,
      1,
      1.097042,
      1,
      4,
      1.018638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.197494,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1.892861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.724175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.734304,
      0,
      3,
      1.900856,
      1,
      NULL,
      0.260402,
      NULL,
      NULL,
      NULL,
      0.086877,
      0.973385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.005443,
      0,
      NULL,
      3.332690,
      NULL,
      0,
      NULL,
      1.473129,
      1.202014,
      0.181558,
      0,
      NULL,
      1,
      1,
      1,
      0.441073,
      1,
      NULL,
      1.000580,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      0.367119,
      4.157865,
      NULL,
      5.849089,
      1.154628,
      2,
      NULL);
commit;
end;
/


