set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '104',
      NULL,
      41,
      63.888023,
      '4203122',
      103.809278,
      5,
      2.325792,
      2,
      '331243',
      2,
      ' 1- 2-1980',
      10,
      34.164127,
      1.439278,
      NULL,
      NULL,
      NULL,
      NULL,
      1.032056,
      1,
      2,
      NULL,
      1,
      0.079346,
      1.321350,
      1,
      0.208051,
      NULL,
      0,
      1.400741,
      0.281573,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.848063,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.063028,
      0,
      0,
      0,
      1.722552,
      NULL,
      NULL,
      0.392415,
      0.414348,
      0,
      3.876086,
      1,
      0.671084,
      1,
      NULL,
      0,
      1.886698,
      0,
      2.355587,
      1,
      NULL,
      NULL,
      2,
      1,
      0,
      2,
      0.866901,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.143771,
      0,
      1,
      0.341504,
      2.577031,
      NULL,
      1,
      NULL,
      0.420806,
      1,
      0,
      1.100311,
      0.158330,
      0,
      1.151974,
      0.174027,
      0.480666,
      1.203097,
      1.329749,
      NULL,
      1.804163,
      1,
      1.246382,
      1.896460,
      1,
      1,
      1,
      1,
      0,
      0.652497,
      NULL,
      NULL,
      0,
      0.474679,
      NULL,
      0.098073,
      2,
      NULL,
      1.182903,
      1,
      2,
      1,
      5.619792,
      NULL,
      0.392193,
      1,
      4,
      4,
      2.759782,
      1,
      0,
      2.565091,
      0.340939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.381207,
      1.492718,
      0,
      1,
      1,
      1.755286,
      1,
      0.819936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.621665,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.385878,
      1.097642,
      NULL,
      1,
      0,
      NULL,
      1,
      4,
      1,
      1.380875,
      0.223665,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.664729,
      2,
      2,
      2,
      NULL,
      1,
      0,
      0,
      0.509074,
      0.626889,
      NULL,
      1,
      0,
      1,
      1,
      0.305080,
      1.214672,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.576809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.770795,
      '03301',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.456568,
      1.847083,
      0.012717,
      3.194993,
      5,
      3.652595,
      NULL,
      3,
      NULL);
commit;
end;
/


