set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '221',
      '43303041',
      19.630573,
      45.562746,
      '0332224',
      81.887098,
      1,
      1.795681,
      1,
      '233021',
      2.985292,
      NULL,
      57.652249,
      235.930636,
      1,
      NULL,
      3.190288,
      0,
      1,
      0,
      1,
      2.508694,
      0.964529,
      0,
      1,
      1,
      4.061322,
      1,
      NULL,
      1.895734,
      1,
      NULL,
      2.109816,
      0.020163,
      0,
      1.076249,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.692532,
      1.602969,
      1,
      0,
      0,
      1,
      1,
      1,
      1.885865,
      0.353377,
      0,
      1,
      3.790890,
      1.079999,
      NULL,
      0.582558,
      0.179235,
      2.222931,
      3.452689,
      1,
      NULL,
      3.607315,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1.393396,
      3,
      0.807813,
      0.364098,
      NULL,
      NULL,
      1.186453,
      1,
      1,
      NULL,
      0,
      0,
      NULL,
      1.906175,
      0,
      0.780764,
      NULL,
      1,
      1.064287,
      1.972112,
      0.243856,
      0,
      1.902683,
      NULL,
      1,
      1,
      1,
      1.947594,
      0,
      0.356059,
      0.892011,
      1.621267,
      0.321662,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.057849,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      1,
      7,
      1.818368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018194,
      NULL,
      1,
      1,
      0,
      1.835862,
      0.113290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453617,
      3,
      1,
      0.964753,
      0.489626,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      1.972541,
      0.024165,
      0,
      1.836775,
      NULL,
      1.871863,
      1,
      1.952138,
      NULL,
      1,
      NULL,
      1,
      1.601329,
      0,
      0.883669,
      1.927704,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '04424',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1.041431,
      NULL,
      '',
      NULL,
      5.612251,
      5.772445,
      1.946068,
      2.131069,
      NULL,
      0,
      2.095683,
      0,
      NULL);
commit;
end;
/


