set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8916689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '0223243',
      NULL,
      0,
      1,
      3,
      '021124',
      0,
      '10- 8-1993',
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0.245683,
      0,
      NULL,
      1.645180,
      1.584207,
      NULL,
      NULL,
      NULL,
      3,
      0.298076,
      5.736333,
      8.885422,
      1,
      NULL,
      0,
      1,
      1,
      2.974450,
      1,
      0.976384,
      1,
      0,
      1.554786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.251382,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.396396,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.904070,
      1,
      0,
      5.393474,
      4,
      0.856357,
      3,
      7.921192,
      3,
      0,
      0.591341,
      1,
      1,
      NULL,
      1,
      1,
      0.470670,
      NULL,
      0,
      0.013342,
      0.046083,
      1.048873,
      1.069018,
      NULL,
      5,
      NULL,
      0,
      NULL,
      2.451579,
      NULL,
      NULL,
      2,
      NULL,
      5,
      NULL,
      5.588037,
      1.887810,
      6.539395,
      NULL,
      6.642493,
      3.126538,
      6.339158,
      0,
      1,
      3,
      1,
      2,
      1,
      0,
      0,
      0.574294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      NULL,
      0.401530,
      4,
      1.940009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.564515,
      1.604766,
      0,
      0.251501,
      3,
      NULL,
      0.301296,
      1,
      0.503240,
      NULL,
      NULL,
      NULL,
      7.321383,
      NULL,
      4.037151,
      3,
      0.354524,
      2,
      1.390887,
      NULL,
      NULL,
      NULL,
      0.059354,
      5,
      1.511376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.341664,
      2,
      1.767360,
      0.879407,
      3,
      3.430833,
      0.506138,
      NULL,
      1.714790,
      0,
      NULL,
      0,
      1.887238,
      0.597745,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.562037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.892824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.538863,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.064691,
      NULL,
      0.258339,
      0,
      0.932519,
      0,
      0,
      '14034',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1.466162,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


