set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8916689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      '2132044',
      24.153266,
      5,
      0.129546,
      2,
      '041024',
      0,
      NULL,
      20.390681,
      NULL,
      0.774405,
      NULL,
      3,
      3.932027,
      NULL,
      0.343825,
      1.689516,
      0,
      NULL,
      NULL,
      3.451659,
      0.218109,
      2,
      1,
      1.684770,
      1,
      NULL,
      3,
      0,
      1,
      1.436371,
      1,
      3.925620,
      0,
      0,
      0,
      4.136321,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.814366,
      NULL,
      NULL,
      0.605916,
      1.590485,
      1.991505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.672518,
      0.100730,
      1.810817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      0.809094,
      4,
      5,
      0.142472,
      1,
      0.662895,
      1,
      6,
      0,
      NULL,
      7,
      0.417409,
      0.557476,
      1,
      1,
      1.619358,
      NULL,
      0.299743,
      1.817387,
      NULL,
      5,
      3,
      1.717478,
      0,
      1.607909,
      0,
      NULL,
      1.008458,
      4.084000,
      NULL,
      5,
      4,
      4.353325,
      5.934652,
      1,
      10,
      0,
      5.338499,
      NULL,
      5.850192,
      4.090686,
      9,
      6,
      1.422686,
      NULL,
      1,
      0.364963,
      NULL,
      4.923279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.390418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.610550,
      0.258789,
      1.749665,
      NULL,
      5.758083,
      11.871986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.247885,
      NULL,
      8.227000,
      10.307279,
      1.056297,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      11.626775,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.218429,
      2.592824,
      3,
      NULL,
      3.347916,
      1.587097,
      0,
      1,
      1,
      NULL,
      1.905014,
      0,
      1.583118,
      1,
      1,
      0.148528,
      NULL,
      0.676369,
      1.725981,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.290841,
      NULL,
      NULL,
      NULL,
      NULL,
      0.879340,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.052686,
      NULL,
      NULL,
      0,
      1,
      0.916713,
      1,
      3,
      '01314',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


