set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8916689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-1-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '3334432',
      9.877604,
      3,
      1,
      3,
      '004101',
      1.445172,
      ' 4-27-1989',
      23,
      NULL,
      NULL,
      NULL,
      0,
      1.194031,
      0.631356,
      0,
      1.345459,
      2,
      1.256984,
      1.000118,
      2.340911,
      1.467725,
      0.855483,
      1.157870,
      NULL,
      NULL,
      0,
      0.376873,
      NULL,
      0.284860,
      3.613709,
      1,
      0,
      NULL,
      3,
      0,
      4,
      1,
      1.994177,
      NULL,
      NULL,
      NULL,
      1.859529,
      NULL,
      NULL,
      NULL,
      0.842749,
      1,
      1.540491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588671,
      0.279980,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      0.454821,
      3,
      1.545129,
      NULL,
      0.250988,
      1.895777,
      0,
      1.752003,
      3,
      NULL,
      2,
      0.611510,
      0.354415,
      1,
      NULL,
      0.175902,
      NULL,
      1,
      1.419783,
      NULL,
      NULL,
      1.645663,
      0,
      4.232123,
      0,
      1.985469,
      0,
      NULL,
      0.539117,
      NULL,
      0.594091,
      1.559918,
      5,
      2,
      NULL,
      9,
      NULL,
      4.078478,
      5,
      NULL,
      NULL,
      NULL,
      4,
      3.837128,
      1,
      0.109605,
      1.982835,
      1,
      1.650673,
      0.346284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.117040,
      0,
      NULL,
      NULL,
      0,
      0.264207,
      0.266356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599738,
      NULL,
      NULL,
      NULL,
      NULL,
      1.987287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.326790,
      1.721537,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4,
      2.355707,
      0.414751,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337643,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.027530,
      NULL,
      2,
      1.066927,
      2,
      0.402208,
      NULL,
      1.305755,
      0.072303,
      0,
      1,
      1,
      1.887565,
      NULL,
      1.822053,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.976458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.511805,
      '24102',
      NULL,
      '',
      1.542582,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


