set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8916689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      NULL,
      NULL,
      '1413303',
      35.543373,
      NULL,
      NULL,
      0,
      '424142',
      2,
      ' 7- 4-1978',
      0,
      NULL,
      1.640984,
      NULL,
      3,
      0,
      1,
      1.506622,
      1,
      1,
      0,
      1.560620,
      3.675478,
      0.598133,
      7,
      0,
      1,
      0,
      3,
      1,
      6,
      2.879825,
      NULL,
      1.861001,
      NULL,
      0.862314,
      5.127729,
      NULL,
      1.947936,
      1.658310,
      1.880200,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.040828,
      NULL,
      3.255683,
      NULL,
      1,
      NULL,
      1.738233,
      1.734264,
      0,
      0.052573,
      1.048236,
      0,
      NULL,
      0.453610,
      NULL,
      3.504512,
      1,
      1,
      0,
      1,
      0.404695,
      0.570917,
      3,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0.470583,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      3.650186,
      0,
      0,
      1.287655,
      2.370593,
      2,
      0.787385,
      0,
      0.119792,
      4.192309,
      0,
      0.747572,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      0.049842,
      NULL,
      NULL,
      1.092002,
      NULL,
      1.848965,
      NULL,
      0.704040,
      1.435270,
      1,
      0.968373,
      3,
      NULL,
      8.277252,
      3,
      7.957397,
      NULL,
      3,
      9,
      7,
      3.245323,
      3.393216,
      2,
      0.229848,
      0,
      NULL,
      3.524574,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1.180889,
      1.788703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1.253009,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.621999,
      1.163167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.789216,
      1.695771,
      1.153643,
      0,
      1.568747,
      1.349303,
      0.233970,
      3,
      0.931226,
      1.133872,
      1,
      0,
      1.223731,
      1.197120,
      NULL,
      1.133729,
      1.210836,
      1.910780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.876403,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081702,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0.789677,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


