set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8607971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      NULL,
      NULL,
      '1423432',
      1,
      2,
      NULL,
      1,
      '330024',
      NULL,
      ' 0-22-1986',
      41,
      NULL,
      1,
      NULL,
      1,
      2.746492,
      0.858738,
      1,
      0.046250,
      1.636194,
      1.216433,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      11,
      2,
      NULL,
      NULL,
      1.634362,
      1.230685,
      7,
      1,
      NULL,
      1,
      1,
      0.961823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.265074,
      1,
      NULL,
      2.527665,
      1.102394,
      NULL,
      NULL,
      0,
      NULL,
      2.096518,
      NULL,
      0.003079,
      3.645649,
      NULL,
      3,
      NULL,
      1,
      0,
      1.757062,
      7,
      3,
      0,
      3.631954,
      NULL,
      0,
      2.393969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.949436,
      4,
      0,
      0,
      3,
      0,
      1.693821,
      NULL,
      0.069732,
      1.462239,
      1.365633,
      1.894694,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.383056,
      1.381796,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.997952,
      NULL,
      1,
      NULL,
      1.568212,
      1.917132,
      NULL,
      1.735795,
      1.784972,
      1.655500,
      0,
      1.897039,
      4,
      4.069657,
      3.378383,
      3.439497,
      0.267143,
      1,
      1.534836,
      3.744167,
      NULL,
      1.068426,
      1.558398,
      0,
      0,
      1.954191,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.907719,
      1,
      0.672837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.333032,
      NULL,
      1,
      NULL,
      0,
      1.295384,
      0.347655,
      1,
      NULL,
      1.565539,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.321148,
      1,
      NULL,
      0,
      0,
      0,
      1.668477,
      NULL,
      NULL,
      NULL,
      1.462560,
      1.094970,
      1.986622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.689446,
      0,
      1.728649,
      1,
      2,
      0,
      0,
      0.334039,
      0.633671,
      2,
      1,
      1.109013,
      0.688056,
      1,
      1.541277,
      0.139651,
      1,
      NULL,
      1,
      3.076517,
      1.121181,
      NULL,
      NULL,
      0.466855,
      0.186807,
      1,
      1.882577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274716,
      0.543453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.247612,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.964003,
      NULL,
      0.309363,
      NULL,
      NULL,
      1,
      0,
      1.856054,
      1.999250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991061,
      NULL,
      NULL,
      NULL,
      NULL,
      0.162001,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '22343',
      '',
      '',
      1.204033,
      NULL,
      '',
      '',
      0.837718,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


