set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8607971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '3034303',
      5,
      1,
      0,
      3,
      '332430',
      0.537831,
      ' 6- 3-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      0.684490,
      1.780147,
      0,
      0,
      0,
      0,
      1,
      0,
      0.008279,
      0.852780,
      NULL,
      1,
      NULL,
      1.391778,
      1.083867,
      3,
      7.542763,
      1.965834,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.460471,
      1,
      1.161644,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1.060228,
      0,
      0,
      2.799971,
      0.158884,
      2,
      0.002035,
      1.985333,
      3,
      0,
      NULL,
      2.747687,
      0,
      1,
      1,
      4.983646,
      3,
      NULL,
      10.116070,
      0,
      2,
      3.446118,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.238431,
      0.533121,
      3.027853,
      0.238801,
      0,
      3,
      0.756405,
      1,
      1,
      NULL,
      0,
      0.127041,
      NULL,
      NULL,
      NULL,
      1,
      0.081665,
      0,
      NULL,
      NULL,
      0.009047,
      1.616887,
      1,
      NULL,
      1,
      1.877653,
      0,
      1,
      1,
      0.534535,
      1.123684,
      1.583759,
      1,
      1,
      0,
      0.306504,
      1,
      0.447347,
      2.279141,
      5,
      5.915520,
      5.408239,
      3.874458,
      4,
      9.855596,
      3.687088,
      NULL,
      6.143462,
      0,
      0,
      1,
      3,
      0.321117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.753184,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7.924184,
      1.930575,
      2.539849,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.178689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052947,
      NULL,
      9,
      5.849534,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.754883,
      0.432572,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.865535,
      2,
      1,
      3.233989,
      1,
      0.237033,
      NULL,
      NULL,
      2,
      0,
      1.522231,
      0,
      1,
      0,
      1,
      0.789374,
      0.050590,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      '',
      '',
      0.301313,
      '',
      '',
      '',
      0.915628,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


