set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8607971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      NULL,
      '4023210',
      42,
      0,
      1.970319,
      2,
      NULL,
      1.603882,
      NULL,
      39.066636,
      NULL,
      1,
      NULL,
      5,
      0,
      1.658928,
      NULL,
      1.542778,
      3.397754,
      1,
      0.749069,
      NULL,
      0,
      11.690891,
      0,
      1.401814,
      NULL,
      0,
      NULL,
      7.156738,
      1.127676,
      NULL,
      0.390060,
      NULL,
      4.577796,
      2,
      NULL,
      2,
      1.477093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.960348,
      0,
      2.467405,
      NULL,
      0,
      1,
      1.088837,
      1,
      NULL,
      2,
      1.286518,
      0.294975,
      0,
      3,
      2.326149,
      1.108361,
      NULL,
      0.908969,
      NULL,
      1.397206,
      1.865619,
      5.885013,
      NULL,
      1,
      1,
      0.055246,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.989281,
      0,
      1.876010,
      1,
      1,
      0.950997,
      0.217485,
      0.012460,
      1,
      3.794908,
      NULL,
      NULL,
      0,
      NULL,
      0.005974,
      NULL,
      NULL,
      0,
      1.123624,
      NULL,
      0.997626,
      3.446518,
      0,
      1,
      0.109775,
      2,
      NULL,
      NULL,
      3,
      NULL,
      0.665898,
      NULL,
      NULL,
      0.849662,
      4,
      2.445063,
      0,
      7,
      5,
      5,
      2.976350,
      NULL,
      7,
      NULL,
      4.388211,
      NULL,
      8,
      NULL,
      NULL,
      0.181639,
      0.295286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.319502,
      NULL,
      1,
      1,
      1.053302,
      0.042532,
      1,
      0.355584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.592897,
      1.446393,
      NULL,
      1,
      0.164139,
      NULL,
      NULL,
      NULL,
      1.787923,
      0,
      1.705105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.802075,
      3,
      2.399110,
      1,
      3,
      NULL,
      0,
      2,
      1,
      NULL,
      1.045763,
      NULL,
      0.783531,
      1.131375,
      NULL,
      1.613297,
      1.171144,
      0.542008,
      NULL,
      1.810018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '',
      '',
      1.123389,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


