set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8607971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      '1223332',
      31,
      5,
      1.399202,
      1,
      '333434',
      0.195105,
      ' 2-16-1978',
      25,
      NULL,
      1,
      NULL,
      NULL,
      0.292935,
      0.043200,
      1.004659,
      0.049983,
      3.552902,
      0,
      1,
      0,
      0.119616,
      9.992807,
      1.006960,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.116928,
      7,
      NULL,
      NULL,
      6.645621,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1.431426,
      NULL,
      NULL,
      4,
      3,
      7,
      NULL,
      1.949764,
      0.787778,
      0.450371,
      0,
      1,
      NULL,
      0,
      0.065002,
      NULL,
      1,
      3.236141,
      1.864574,
      0,
      0,
      1,
      7.652378,
      0.744014,
      3,
      3.104696,
      1,
      1,
      3,
      0.227958,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.813798,
      0.448796,
      5,
      0.377852,
      1,
      0.145906,
      3,
      1,
      0.166426,
      5,
      0,
      1,
      1.208944,
      2,
      1.876855,
      1.373738,
      0,
      0,
      0.637522,
      NULL,
      0.703389,
      NULL,
      NULL,
      2.408228,
      0,
      0.324940,
      0,
      0,
      NULL,
      1,
      1,
      3,
      NULL,
      1,
      1,
      3.445881,
      0.538034,
      4.357834,
      4,
      7,
      4.360455,
      NULL,
      4.609386,
      2,
      8.573162,
      NULL,
      0,
      3,
      0.769538,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.168746,
      1,
      NULL,
      NULL,
      3.264777,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.633311,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.407300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.447710,
      1,
      8.170979,
      4,
      0,
      0,
      0.004761,
      NULL,
      NULL,
      NULL,
      1,
      2.252982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.497097,
      0.855515,
      NULL,
      0.219928,
      0.553127,
      0,
      NULL,
      NULL,
      0.174815,
      2,
      0.906803,
      0,
      NULL,
      1.584707,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.040452,
      '42132',
      NULL,
      '',
      1,
      NULL,
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


