set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8607971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      NULL,
      '0420002',
      NULL,
      0,
      0,
      3,
      '330332',
      1,
      ' 3-11-1989',
      24.161145,
      NULL,
      0.632957,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0.731132,
      NULL,
      0.210864,
      0.363930,
      0.118953,
      1,
      11,
      1,
      1,
      0,
      NULL,
      3,
      3.244626,
      NULL,
      NULL,
      NULL,
      5,
      9,
      3.986341,
      1,
      3,
      NULL,
      2.501012,
      NULL,
      NULL,
      NULL,
      1.985745,
      NULL,
      NULL,
      7,
      1,
      1,
      3,
      0,
      NULL,
      0,
      0.993719,
      0,
      1,
      1.837639,
      1,
      1,
      0,
      0,
      2,
      2.907139,
      3.451341,
      3,
      NULL,
      NULL,
      NULL,
      10.578730,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      2.723560,
      NULL,
      1.589472,
      1.155227,
      0,
      0,
      NULL,
      1,
      1.321754,
      1,
      1,
      0.344094,
      1.427750,
      NULL,
      1.722772,
      1,
      0,
      NULL,
      1,
      0.859863,
      NULL,
      NULL,
      1,
      1,
      1,
      0.500915,
      0.795896,
      NULL,
      1.649650,
      0,
      0,
      NULL,
      3.963418,
      0,
      0,
      2,
      5,
      9,
      6,
      1,
      6.256471,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271438,
      NULL,
      1.731746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.789318,
      NULL,
      1,
      1,
      0,
      0,
      0.217686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.038321,
      2,
      3.222868,
      4.050414,
      3,
      2,
      0.391424,
      0,
      7,
      8,
      0.548994,
      NULL,
      2.553773,
      NULL,
      0.536785,
      NULL,
      0.743190,
      0,
      0,
      NULL,
      2,
      0.182984,
      0,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.443900,
      2,
      0,
      2,
      0.416214,
      NULL,
      1,
      3,
      1.513857,
      0.544444,
      1.832719,
      1,
      0.222421,
      NULL,
      1.165800,
      0,
      NULL,
      0.815280,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '13123',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


