set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8607971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      2.186791,
      NULL,
      NULL,
      0,
      ' 5-11-1976',
      7,
      NULL,
      1.220326,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0.577971,
      0,
      1,
      1,
      1,
      3.977472,
      1.954809,
      0.777472,
      0,
      0,
      7,
      1.266153,
      10,
      6,
      0.959061,
      NULL,
      5,
      11,
      1,
      2.477464,
      1.051027,
      NULL,
      0.387761,
      NULL,
      NULL,
      0.362264,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      NULL,
      1.733515,
      2.273933,
      NULL,
      1,
      1,
      1,
      NULL,
      3,
      3.532795,
      0,
      NULL,
      0.061852,
      1.473800,
      0,
      1.787013,
      0.017074,
      0.434954,
      NULL,
      1,
      2,
      1,
      0.522766,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.662974,
      NULL,
      1,
      NULL,
      4.265379,
      0.775370,
      1.966546,
      0.578835,
      1,
      1.014492,
      3,
      3.735048,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      6.291417,
      5.653272,
      6,
      NULL,
      1,
      0,
      1.216587,
      1,
      0,
      5.035552,
      0,
      NULL,
      NULL,
      0.249085,
      4.828530,
      4,
      0,
      NULL,
      1,
      3,
      2,
      6.316268,
      NULL,
      NULL,
      3,
      3.121077,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.708501,
      NULL,
      0,
      0.237514,
      0,
      0,
      1.363355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.568666,
      NULL,
      NULL,
      0.792628,
      0,
      1.823525,
      NULL,
      2.864266,
      0,
      1,
      2.395161,
      2.819652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.203816,
      2,
      1.047475,
      1.880773,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.809738,
      NULL,
      1.947896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.263871,
      0.353856,
      0.163859,
      1,
      1.137871,
      0.419860,
      3,
      NULL,
      NULL,
      1,
      1,
      1.635473,
      0,
      1,
      0,
      NULL,
      0.734664,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '32203',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      1.569075,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


