set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8607971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-8-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      NULL,
      NULL,
      '2422122',
      57.912895,
      5,
      2,
      1,
      '112404',
      3,
      NULL,
      17.094738,
      NULL,
      1.878891,
      NULL,
      4,
      2.046127,
      0,
      1,
      0.056217,
      3,
      3,
      NULL,
      0,
      0.858516,
      9.400626,
      1,
      1,
      NULL,
      0,
      6.804317,
      NULL,
      8,
      NULL,
      0.731606,
      NULL,
      NULL,
      7.149786,
      NULL,
      4.297980,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.678511,
      1.939932,
      NULL,
      2.483001,
      3,
      2.530136,
      NULL,
      1.670530,
      0,
      3,
      2.131642,
      0,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      10,
      0.125099,
      1,
      2,
      2,
      0,
      NULL,
      NULL,
      0.297723,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      1.722475,
      NULL,
      1.430967,
      0,
      0.220690,
      1.846732,
      3,
      1.991442,
      NULL,
      NULL,
      0.565382,
      NULL,
      1,
      0.841036,
      1,
      NULL,
      0,
      2.426243,
      1.218296,
      1.681138,
      0.146585,
      5.032844,
      1,
      1.878506,
      1,
      1.445728,
      2,
      0.801610,
      0,
      1,
      NULL,
      1.647034,
      1,
      6,
      NULL,
      1,
      NULL,
      9.562790,
      4.074089,
      3,
      3.896731,
      5.325806,
      3,
      1.151621,
      NULL,
      1.955583,
      1,
      0,
      0.111205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1.774210,
      3,
      0.427009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5.087133,
      2,
      0,
      2,
      0.446630,
      NULL,
      1,
      1.250111,
      5.955763,
      0,
      1,
      NULL,
      2.651071,
      3,
      1,
      2,
      0,
      6.905629,
      6.856463,
      4.942533,
      1,
      3,
      1.985701,
      NULL,
      NULL,
      1,
      4.315370,
      0.063061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.597635,
      2,
      0.952273,
      1,
      1,
      3.529996,
      0,
      0.671317,
      1.132651,
      NULL,
      1.366297,
      1.149191,
      0.306680,
      1,
      0.260874,
      NULL,
      0.415395,
      NULL,
      1,
      0.829208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '13402',
      '',
      '',
      0.177099,
      '',
      '',
      '',
      1.091617,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


