set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8607971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      '3110000',
      11,
      5,
      2,
      NULL,
      '133240',
      2.068211,
      ' 2-26-1986',
      26,
      NULL,
      0.212607,
      NULL,
      0,
      2.371087,
      NULL,
      0.659496,
      1.314095,
      1.680920,
      0.573795,
      0,
      1,
      1.504662,
      NULL,
      0,
      1.042105,
      1,
      1,
      4,
      3.464673,
      2.368271,
      0,
      1.263064,
      NULL,
      9.036653,
      4,
      NULL,
      2.045162,
      0.431221,
      1,
      0.616459,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0,
      1.584028,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      NULL,
      2.393780,
      0,
      2,
      NULL,
      0,
      0.816875,
      0.175650,
      7.992264,
      NULL,
      1,
      7.614045,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.382888,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      3.606048,
      1,
      1.922057,
      0.394738,
      1,
      0.180286,
      1.490081,
      1,
      0,
      0,
      0,
      0.563787,
      0,
      0.247316,
      1,
      NULL,
      NULL,
      0.534466,
      1.722639,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      1,
      4,
      1.604025,
      0.109020,
      0,
      NULL,
      1,
      NULL,
      2.424096,
      NULL,
      NULL,
      1.365812,
      4,
      6,
      1.982745,
      1,
      0.509616,
      0,
      1,
      1.766739,
      1.859825,
      0.398953,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868772,
      0,
      0,
      0,
      1,
      1.203608,
      5.018581,
      0.159501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.599166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.626041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.977917,
      2.602808,
      1.986079,
      0,
      0.991455,
      NULL,
      NULL,
      NULL,
      0,
      3.522171,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.627917,
      0.548136,
      0.715811,
      0.333839,
      0.356354,
      0.585548,
      0.585161,
      0,
      0.752843,
      0,
      1,
      0.144635,
      NULL,
      1.477967,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1.545989,
      1.516484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0.126718,
      0,
      0.682318,
      1,
      3.790716,
      '23442',
      NULL,
      NULL,
      1.141440,
      '',
      '',
      '',
      0.171928,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


