set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8607971';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-1-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      NULL,
      NULL,
      '3413233',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      ' 1- 8-2000',
      35.722284,
      NULL,
      0.137849,
      NULL,
      0.696901,
      NULL,
      1.610567,
      1,
      1,
      1.204003,
      1,
      0.005431,
      NULL,
      1,
      4,
      1.012881,
      1.015581,
      NULL,
      1.553986,
      0.169414,
      3.011391,
      9,
      4.416832,
      8,
      8.488405,
      NULL,
      9.643823,
      0,
      3.102082,
      1,
      2.075819,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.742484,
      1.600610,
      NULL,
      1.136865,
      0,
      2.424779,
      0.539735,
      1.586099,
      3.414051,
      1.834749,
      1.844507,
      2,
      NULL,
      3,
      0.960103,
      1.526425,
      1,
      0.755158,
      3,
      NULL,
      NULL,
      0.373974,
      0,
      2,
      5.583501,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.690682,
      0,
      1.286252,
      1,
      1,
      1.157495,
      NULL,
      1.801124,
      1.619081,
      1.826163,
      0,
      0,
      1.355085,
      0,
      0.043490,
      NULL,
      NULL,
      0.996389,
      0.228598,
      NULL,
      NULL,
      0.168193,
      1.122609,
      0,
      0.807000,
      NULL,
      NULL,
      0.391108,
      5,
      NULL,
      1,
      2.362096,
      1.394117,
      0.756986,
      5,
      NULL,
      0.506569,
      5,
      6,
      NULL,
      4.422169,
      NULL,
      7,
      5.092293,
      2,
      NULL,
      1,
      1.384690,
      NULL,
      0.278096,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.123545,
      NULL,
      2,
      1,
      0.906667,
      2.128324,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      4.464719,
      NULL,
      3.209619,
      2,
      1.154208,
      2,
      1,
      NULL,
      5,
      7.451183,
      NULL,
      1.733433,
      NULL,
      NULL,
      NULL,
      3.659022,
      NULL,
      2,
      2.836924,
      1.410685,
      1,
      7.492446,
      0.975444,
      NULL,
      NULL,
      1.332738,
      0.338645,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.623074,
      1,
      1,
      0.278911,
      0.398569,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      1.357631,
      1.073376,
      0,
      1,
      NULL,
      NULL,
      1.479158,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.763931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.723607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.272366,
      NULL,
      NULL,
      0.220413,
      1,
      1,
      2,
      '11113',
      '',
      '',
      1.063618,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


