set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015909';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '222',
      '12100441',
      NULL,
      27,
      '3433110',
      21.803000,
      4,
      0,
      NULL,
      '432324',
      2,
      ' 7- 9-1999',
      14,
      25.885290,
      0.825535,
      NULL,
      0,
      0.767511,
      3,
      0,
      0.764833,
      1.301231,
      1,
      NULL,
      1,
      0.276231,
      4.183643,
      NULL,
      0,
      4.970488,
      NULL,
      NULL,
      0.593644,
      0,
      1.410341,
      1.904526,
      4,
      1,
      1,
      1,
      NULL,
      2.224404,
      0.089307,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.995088,
      NULL,
      1.826091,
      3.943434,
      0,
      NULL,
      3,
      2,
      1.900283,
      NULL,
      1,
      0,
      1.845018,
      NULL,
      1,
      0.500328,
      0,
      0.472638,
      3.301407,
      0,
      NULL,
      3.951182,
      3,
      0,
      0,
      2,
      0.928525,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.467975,
      NULL,
      NULL,
      0,
      1,
      1.923713,
      NULL,
      1.925336,
      1,
      0.122189,
      1,
      0.966094,
      0.736037,
      NULL,
      0,
      1.252647,
      1.103730,
      0.045504,
      0,
      NULL,
      0.177282,
      NULL,
      5,
      1,
      NULL,
      3.114097,
      3.973249,
      1.143362,
      1,
      1.762999,
      0,
      0,
      0,
      NULL,
      2,
      1,
      1,
      1.089581,
      1.365184,
      1,
      NULL,
      4.958933,
      NULL,
      1,
      1.131418,
      1.116102,
      NULL,
      0,
      1.202206,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0.478701,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187961,
      1,
      0.930422,
      0,
      0,
      NULL,
      0.577660,
      NULL,
      NULL,
      NULL,
      1.929317,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.686982,
      3.495576,
      NULL,
      NULL,
      NULL,
      0.054091,
      0.545012,
      0,
      NULL,
      1,
      1,
      0,
      0.870372,
      1.518716,
      NULL,
      1,
      NULL,
      1.303534,
      1.634974,
      1.553860,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      '24131',
      '02240',
      '',
      NULL,
      '',
      '',
      '',
      1.335912,
      NULL,
      '',
      '',
      1,
      0.063878,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3);
commit;
end;
/


