set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015909';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '121',
      NULL,
      NULL,
      40.442664,
      '1334000',
      48,
      5,
      1.938922,
      NULL,
      '211340',
      3,
      ' 7-17-1980',
      52,
      4,
      1.339701,
      NULL,
      2,
      3.884204,
      1,
      1.071081,
      NULL,
      0.778141,
      0.653722,
      2.698692,
      0,
      NULL,
      0.412473,
      1.046995,
      0,
      2,
      3,
      1.340649,
      4.851335,
      3,
      NULL,
      1.999432,
      1,
      NULL,
      6.248395,
      1,
      3,
      3.273820,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      1,
      0,
      0,
      1.224431,
      1,
      NULL,
      2,
      0,
      3,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      1.073212,
      1.061312,
      0.258825,
      0.191918,
      3.367222,
      1,
      1,
      1,
      1.208592,
      0.715199,
      NULL,
      NULL,
      1.722697,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3.934676,
      NULL,
      1,
      0.967056,
      1,
      0.717048,
      0,
      NULL,
      1,
      1.099011,
      0,
      0.594122,
      0.989371,
      1,
      1.076284,
      NULL,
      0.947438,
      0.148821,
      1,
      0.075497,
      3.358900,
      3,
      2,
      0.859396,
      2,
      1.515281,
      0.452239,
      0,
      NULL,
      NULL,
      1,
      5,
      4.799998,
      1.943192,
      0.740947,
      NULL,
      3.721031,
      1,
      NULL,
      3.983461,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      3.698646,
      0,
      0.262492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.580326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.369687,
      1.306925,
      1.424795,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.364799,
      3,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      0.325856,
      NULL,
      NULL,
      NULL,
      0.452013,
      0,
      0,
      NULL,
      1.768588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '00434',
      '11041',
      '',
      0.363266,
      '',
      '',
      '',
      0.977068,
      '',
      '',
      '',
      2,
      4.434281,
      3.458528,
      1,
      NULL,
      2.866788,
      NULL,
      3,
      0.373689);
commit;
end;
/


