set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015909';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '132',
      '24234331',
      6.435165,
      NULL,
      '1104221',
      73.064891,
      0,
      0.742338,
      1,
      '102020',
      NULL,
      ' 0- 6-1985',
      155,
      42.099856,
      0,
      NULL,
      1.993347,
      1,
      3,
      0,
      1,
      NULL,
      0,
      0.653089,
      1,
      NULL,
      2,
      1.461659,
      0.751010,
      2,
      NULL,
      NULL,
      0,
      2.558556,
      1.194914,
      NULL,
      1,
      1,
      0.572439,
      0,
      1.632790,
      0.314229,
      NULL,
      0.059071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.944543,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.126208,
      0.333972,
      0,
      0.316977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.974481,
      NULL,
      1.462619,
      0.751355,
      3.410653,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0,
      1.244841,
      1.501094,
      NULL,
      0.417158,
      0.772730,
      1,
      0,
      NULL,
      0,
      0,
      0.220066,
      NULL,
      0,
      0,
      3,
      1,
      4.350425,
      1.403591,
      0.185288,
      NULL,
      0,
      0.817304,
      2.855432,
      4,
      5.023611,
      2.459057,
      0,
      5.637746,
      NULL,
      5.680041,
      3.248797,
      3.506680,
      NULL,
      NULL,
      1.934710,
      0.262076,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.683806,
      0.247660,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.798892,
      NULL,
      NULL,
      NULL,
      NULL,
      1.998839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.029962,
      NULL,
      1.763434,
      0,
      0.444217,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.963896,
      1.462352,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.299586,
      3,
      1,
      1.628412,
      0,
      1,
      1.555407,
      1,
      1,
      0,
      0.492039,
      NULL,
      1.249351,
      0,
      1.652969,
      1,
      0.629096,
      1.957455,
      0.467190,
      1.672164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '43013',
      '00224',
      '',
      1,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      3.477704,
      2,
      NULL,
      3.070471,
      3.594092,
      NULL,
      2.268759,
      3);
commit;
end;
/


