set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015909';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '323',
      '43432202',
      42.287287,
      68.806262,
      '4201200',
      70.659806,
      3,
      1,
      2,
      '430123',
      4.803709,
      ' 0-20-1984',
      34,
      184.584263,
      0.033465,
      NULL,
      5.779619,
      NULL,
      1.080190,
      1,
      NULL,
      NULL,
      3.642257,
      0,
      1.924491,
      NULL,
      3.354788,
      0.102444,
      0,
      2.751993,
      0.769574,
      4,
      3,
      NULL,
      1.808871,
      1.278509,
      0,
      0.722313,
      1,
      0,
      2.359477,
      1.509046,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.823597,
      1.714549,
      0.427786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.698341,
      0,
      NULL,
      3.656295,
      1,
      2,
      1,
      1.315715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.271224,
      4,
      NULL,
      5.952587,
      7.136474,
      1,
      1,
      NULL,
      1.516783,
      1.532487,
      NULL,
      1.780780,
      0.697000,
      1.733849,
      1.928635,
      1,
      0.299174,
      NULL,
      0.541693,
      NULL,
      1,
      5.625851,
      0,
      0.562239,
      NULL,
      1,
      1.007668,
      0.167882,
      NULL,
      0,
      NULL,
      3.151467,
      2,
      NULL,
      3.364422,
      6.507174,
      9.564169,
      8,
      1.907197,
      7,
      0,
      4.849586,
      0.521789,
      3,
      2,
      6,
      NULL,
      6,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      NULL,
      1,
      1.307231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2.779043,
      1,
      0,
      2.514974,
      6.907199,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      7,
      0,
      0,
      0.286723,
      NULL,
      NULL,
      NULL,
      0.465973,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.189769,
      1.927666,
      1.891911,
      NULL,
      NULL,
      NULL,
      1.007233,
      0,
      1.554783,
      2.924755,
      NULL,
      NULL,
      1.554414,
      0,
      1.462098,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.753443,
      '32101',
      '11110',
      '',
      1,
      '',
      '',
      NULL,
      0.111492,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      3.087594,
      1.744190,
      NULL,
      0.365607,
      2.908209,
      2.956043);
commit;
end;
/


