set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015909';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '044',
      NULL,
      14.858252,
      46,
      '2142111',
      14,
      5,
      3,
      NULL,
      '300424',
      5,
      ' 0- 0-1989',
      59,
      212,
      NULL,
      NULL,
      3,
      0.786013,
      NULL,
      0.111423,
      1,
      3,
      0.711598,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      6.813258,
      1,
      7.350039,
      NULL,
      1,
      1,
      1.198882,
      0.558307,
      NULL,
      10.512327,
      1,
      4,
      1,
      2.840394,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.576745,
      1,
      0.465476,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.559786,
      0.144683,
      3.822803,
      8,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.250305,
      5,
      11.006306,
      0.039108,
      0,
      0,
      1.922209,
      NULL,
      0.160609,
      0,
      0,
      0.338490,
      0,
      NULL,
      0.558109,
      1,
      1.377372,
      1.576844,
      0.125986,
      NULL,
      1.662069,
      0,
      NULL,
      0.792154,
      7,
      1,
      4,
      0,
      7,
      NULL,
      1,
      2.881427,
      1.165428,
      1,
      7,
      1.431944,
      8.303741,
      2.939843,
      11,
      4.828237,
      1.465960,
      NULL,
      6.849122,
      NULL,
      6,
      2,
      0.019912,
      4.808677,
      2,
      1.601352,
      0.545089,
      3.225949,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.202290,
      0.636735,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.439986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268121,
      1,
      1.367292,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.295076,
      4,
      0.759811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.064794,
      1.780169,
      0.547112,
      3.483759,
      1,
      1,
      NULL,
      1.719742,
      0,
      1,
      1.277090,
      1.569739,
      1,
      NULL,
      1,
      1.364270,
      1,
      0,
      0,
      0.715699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '04132',
      '20214',
      '',
      0,
      '',
      NULL,
      '',
      0.497903,
      '',
      '',
      '',
      5,
      NULL,
      1,
      NULL,
      2,
      5.739378,
      NULL,
      NULL,
      3);
commit;
end;
/


