set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015909';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1112',
      '14143433',
      19,
      29.182630,
      '0301343',
      43,
      1,
      NULL,
      NULL,
      '404012',
      NULL,
      NULL,
      NULL,
      198,
      1,
      NULL,
      0,
      1,
      NULL,
      1.316230,
      0,
      1,
      0.518203,
      3,
      2.873427,
      NULL,
      2.198371,
      0.993302,
      0.230608,
      NULL,
      0.173293,
      4.848416,
      NULL,
      1,
      1.448057,
      1.601265,
      0.478743,
      1.443312,
      4,
      NULL,
      4.271566,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.633820,
      0.175943,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.226872,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.377890,
      NULL,
      NULL,
      1.670184,
      0,
      0.950592,
      1,
      0,
      NULL,
      0.714103,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      3.081644,
      1,
      0.977727,
      2,
      1,
      NULL,
      0.608930,
      0,
      1,
      3,
      5.308104,
      3.255755,
      1.872426,
      5,
      NULL,
      NULL,
      NULL,
      0,
      7.371717,
      3,
      NULL,
      0,
      0.862628,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      5,
      0.500668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.585925,
      1,
      1,
      1,
      0.642229,
      2.532169,
      0,
      0.709481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.372386,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.908656,
      1,
      3.642711,
      0.966860,
      NULL,
      2.872535,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      2,
      2.903572,
      0.537898,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.170377,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.433388,
      0,
      0.314821,
      0.980105,
      0,
      1.313582,
      NULL,
      1.486846,
      0.622386,
      3.912803,
      0,
      0.699277,
      1.002940,
      NULL,
      NULL,
      0,
      0.633975,
      1,
      0.156097,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.562192,
      '31104',
      '00033',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.634970,
      NULL,
      NULL,
      2.414944,
      2,
      3.665063,
      3,
      NULL,
      0);
commit;
end;
/


