set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015909';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3041',
      NULL,
      45.673150,
      23,
      '3143334',
      102.515782,
      4,
      2.175633,
      2,
      '332004',
      3,
      ' 7- 0-1982',
      NULL,
      28,
      1,
      NULL,
      NULL,
      1,
      2.559094,
      0,
      1,
      1,
      0.578329,
      0.395467,
      0,
      1,
      1.754872,
      1.677436,
      1,
      1.891510,
      NULL,
      2.477784,
      0.049502,
      1,
      1.063559,
      1,
      0.818348,
      1.668881,
      0.541360,
      1,
      1.444759,
      0,
      1,
      0,
      NULL,
      NULL,
      0.877655,
      NULL,
      NULL,
      2.861938,
      0.746128,
      1.007201,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.077446,
      1.574994,
      0.630120,
      4,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.689260,
      NULL,
      NULL,
      0,
      1.981074,
      0,
      NULL,
      0.341214,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1.802217,
      NULL,
      NULL,
      1.914582,
      0,
      NULL,
      0,
      NULL,
      0,
      0.950071,
      1,
      6,
      0,
      2,
      5,
      5.977931,
      1.265227,
      0,
      3,
      3,
      6.510718,
      1.968148,
      3,
      NULL,
      5.955399,
      5.839046,
      0,
      0,
      0,
      NULL,
      1.650670,
      NULL,
      NULL,
      NULL,
      1.873086,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.996794,
      0,
      0,
      NULL,
      1,
      1.679947,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.722975,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.459457,
      0.420044,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.407221,
      3.360464,
      1.042555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.821183,
      0.797631,
      3,
      2.359007,
      1.809951,
      3.881852,
      1.032406,
      0.496626,
      0,
      3,
      0.938996,
      1.728449,
      0,
      0.006816,
      0,
      1,
      1.332849,
      NULL,
      1.525407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '42103',
      '33221',
      '',
      0.915332,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.198612,
      0.506291,
      0,
      1,
      NULL,
      NULL,
      1.057513,
      1,
      1);
commit;
end;
/


